% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/box_plot.R
\name{taxa_boxplot}
\alias{taxa_boxplot}
\title{Function to make boxplots of taxa counts or relative abundance}
\usage{
taxa_boxplot(
  micro_set,
  taxa,
  ...,
  y = ra,
  xlab = NULL,
  ylab = NULL,
  main = NULL,
  subtitle = NULL,
  legend_title = NULL
)
}
\arguments{
\item{micro_set}{A tidy_micro data set}

\item{taxa}{A character string. The name of the taxa of interest}

\item{...}{The factor variable you'd like to stratify by}

\item{y}{The taxa information}

\item{xlab}{x-axis label}

\item{ylab}{y-axis label}

\item{main}{Plot title}

\item{subtitle}{Subtitle for the plot}

\item{legend_title}{Title of plot legend}
}
\value{
A ggplot that you can add geoms to if you'd like
}
\description{
A function to make boxplots of one specified taxa relative abundance with the option to stratify by a factor variable
}
\examples{
data(phy); data(cla); data(ord); data(fam); data(clin)
otu_tabs = list(Phylum = phy, Class = cla, Order = ord, Family = fam)
set <- tidy_micro(otu_tabs = otu_tabs, clinical = clin) \%>\%
filter(day == 7) ## Only including the first week

set \%>\%
taxa_boxplot("Firmicutes/Bacilli/Bacillales/Staphylococcaceae", bpd1)
}
