% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spec_combine.R
\name{tspec_combine}
\alias{tspec_combine}
\title{Combine multiple specifications}
\usage{
tspec_combine(...)
}
\arguments{
\item{...}{Specifications to combine.}
}
\value{
A tibblify specification.
}
\description{
Combine multiple specifications
}
\examples{
# union of fields
tspec_combine(
  tspec_df(tib_int("a")),
  tspec_df(tib_chr("b"))
)

# unspecified + x -> x
tspec_combine(
  tspec_df(tib_unspecified("a"), tib_chr("b")),
  tspec_df(tib_int("a"), tib_variant("b"))
)

# scalar + vector -> vector
tspec_combine(
  tspec_df(tib_chr("a")),
  tspec_df(tib_chr_vec("a"))
)

# scalar/vector + variant -> variant
tspec_combine(
  tspec_df(tib_chr("a")),
  tspec_df(tib_variant("a"))
)
}
