% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{pbc_tbl1}
\alias{pbc_tbl1}
\title{Mayo Clinic Primary Biliary Cirrhosis}
\format{a data frame with 418 rows and 9 variables.
\itemize{
\item age: in years
\item sex: male or female
\item status death, censor, or transplant.
\item trt D-penicillmain, placebo, and not randomized (NA).
\item stage: histologic stage of disease (needs biopsy)
\item ascites: presence of ascites
\item bili: serum bilirunbin (mg/dl)
\item edema: no edema, untreated or successfully treated edema, or
edema despite diuretic therapy
\item albumin: serum albumin (g/dl)
}}
\source{
T Therneau and P Grambsch (2000),
Modeling Survival Data:
Extending the Cox Model,
Springer-Verlag, New York.
ISBN: 0-387-98784-3.
}
\usage{
pbc_tbl1
}
\description{
These data contain a subset of the columns found in
the \code{pbc} data in the \code{survival} package. Also, the description
below is taken from the description provided by the \code{survival}
package.

cirrhosis (PBC) of the liver conducted between 1974 and 1984. A total
of 424 PBC patients, referred to Mayo Clinic during that ten-year
interval, met eligibility criteria for the randomized placebo controlled
trial of the drug D-penicillamine. The first 312 cases in the data set
participated in the randomized trial and contain largely complete data.
The additional 112 cases did not participate in the clinical trial,
but consented to have basic measurements recorded and to be followed
for survival. Six of those cases were lost to follow-up shortly after
diagnosis, so the data here are on an additional 106 cases as well as
the 312 randomized participants.
}
\keyword{datasets}
