% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sparse_cor.R
\name{sparse_cor}
\alias{sparse_cor}
\title{Sparse correlation function}
\usage{
sparse_cor(
  x,
  y = NULL,
  method = "pearson",
  allow_neg = TRUE,
  remove_na = TRUE,
  remove_inf = TRUE,
  ...
)
}
\arguments{
\item{x}{Sparse matrix or character vector.}

\item{y}{Sparse matrix or character vector.}

\item{method}{Method to use for calculating the correlation coefficient.}

\item{allow_neg}{Logical. Whether to allow negative values or set them to 0.}

\item{remove_na}{Logical. Whether to replace NA values with 0.}

\item{remove_inf}{Logical. Whether to replace infinite values with 1.}

\item{...}{Other arguments passed to \link[stats:cor]{stats::cor} function.}
}
\value{
A correlation matrix.
}
\description{
Safe correlation function which returns a sparse matrix without missing values.
}
\examples{
m1 <- simulate_sparse_matrix(
  500, 100
)
m2 <- simulate_sparse_matrix(
  500, 100,
  seed = 2025
)
a <- sparse_cor(m1)
b <- sparse_cor(m1, m2)
c <- as_matrix(
  cor(as_matrix(m1)),
  return_sparse = TRUE
)
d <- as_matrix(
  cor(as_matrix(m1), as_matrix(m2)),
  return_sparse = TRUE
)

a[1:5, 1:5]
c[1:5, 1:5]
all.equal(a, c)

b[1:5, 1:5]
d[1:5, 1:5]
all.equal(b, d)

m1[sample(1:500, 10)] <- NA
m2[sample(1:500, 10)] <- NA

sparse_cor(m1, m2)[1:5, 1:5]

system.time(
  sparse_cor(m1)
)
system.time(
  cor(as_matrix(m1))
)

system.time(
  sparse_cor(m1, m2)
)
system.time(
  cor(as_matrix(m1), as_matrix(m2))
)
}
