% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rescale.R
\name{rescale}
\alias{rescale}
\alias{rescale_standard}
\alias{rescale_normal}
\alias{rescale_log}
\alias{rescale_pointscale}
\title{Standard: Rescale values to a standard normal scale}
\usage{
rescale_standard(x, na_omit = TRUE)

rescale_normal(x, na_omit = TRUE)

rescale_log(x, na_omit = TRUE)

rescale_pointscale(x, lower, upper, lower0 = NULL, upper0 = NULL,
  na_omit = TRUE)
}
\arguments{
\item{x}{Input vector}

\item{na_omit}{Logical indicating whether to drop missing (NA) values.
Default is TRUE.}

\item{lower}{Min value of new scale.
Only applicable for pointscales.}

\item{upper}{Max value of new scale.
Only applicable for pointscales.}

\item{lower0}{Min value of old scale. If NULL, defaults to min of input.
Only applicable for pointscales.}

\item{upper0}{Max value of old scale. If NULL, defaults to max of input
Only applicable for pointscales.}
}
\value{
Rescaled vector
}
\description{
Standard: Rescale values to a standard normal scale

Normal: Rescale values to a standard (0-1) scale

Log: Rescale values to a natural log scale

Point-scale: Rescale values to a new point scale
}
\examples{
## randomly sample 10 values ranging from -10 to 100
x <- sample(-10:100, 10)

## rescale to 0-1 scale
rescale_standard(x)

## rescale to normal distribution (z-scores)
rescale_normal(x)

## rescale to logged distribution (natural log)
rescale_log(x)

## rescale to new point scale
rescale_pointscale(x, 1, 7, lower0 = -10, upper0 = 100)

}
