% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bijector-methods.R
\name{tfb_forward_log_det_jacobian}
\alias{tfb_forward_log_det_jacobian}
\title{Returns the result of the forward evaluation of the log determinant of the Jacobian}
\usage{
tfb_forward_log_det_jacobian(bijector, x, event_ndims,
  name = "forward_log_det_jacobian")
}
\arguments{
\item{bijector}{The bijector to apply}

\item{x}{Tensor. The input to the "forward" Jacobian determinant evaluation.}

\item{event_ndims}{Number of dimensions in the probabilistic events being transformed.
Must be greater than or equal to bijector$forward_min_event_ndims. The result is summed over the final
dimensions to produce a scalar Jacobian determinant for each event, i.e. it has shape
x$shape$ndims - event_ndims dimensions.}

\item{name}{name of the operation}
}
\value{
a tensor
}
\description{
Returns the result of the forward evaluation of the log determinant of the Jacobian
}
\examples{
\donttest{
  b <- tfb_affine_scalar(shift = 1, scale = 2)
  x <- 10
  b \%>\% tfb_forward_log_det_jacobian(x, event_ndims = 0)
}
}
\seealso{
Other bijector_methods: \code{\link{tfb_forward}},
  \code{\link{tfb_inverse_log_det_jacobian}},
  \code{\link{tfb_inverse}}
}
\concept{bijector_methods}
