% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bijector-methods.R
\name{tfb_forward}
\alias{tfb_forward}
\title{Returns the forward Bijector evaluation, i.e., \code{X = g(Y)}.}
\usage{
tfb_forward(bijector, x, name = "forward")
}
\arguments{
\item{bijector}{The bijector to apply}

\item{x}{Tensor. The input to the "forward" evaluation.}

\item{name}{name of the operation}
}
\value{
a tensor
}
\description{
Returns the forward Bijector evaluation, i.e., \code{X = g(Y)}.
}
\examples{
\donttest{
  b <- tfb_affine_scalar(shift = 1, scale = 2)
  x <- 10
  b \%>\% tfb_forward(x)
}
}
\seealso{
Other bijector_methods: \code{\link{tfb_forward_log_det_jacobian}},
  \code{\link{tfb_inverse_log_det_jacobian}},
  \code{\link{tfb_inverse}}
}
\concept{bijector_methods}
