% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glm.R
\name{glm_fit.tensorflow.tensor}
\alias{glm_fit.tensorflow.tensor}
\title{Runs multiple Fisher scoring steps}
\usage{
\method{glm_fit}{tensorflow.tensor}(x, response, model,
  model_coefficients_start = NULL,
  predicted_linear_response_start = NULL, l2_regularizer = NULL,
  dispersion = NULL, offset = NULL, convergence_criteria_fn = NULL,
  learning_rate = NULL, fast_unsafe_numerics = TRUE,
  maximum_iterations = NULL, name = NULL, ...)
}
\arguments{
\item{x}{float-like, matrix-shaped Tensor where each row represents a sample's
features.}

\item{response}{vector-shaped Tensor where each element represents a sample's
observed response (to the corresponding row of features). Must have same \code{dtype}
as \code{x}.}

\item{model}{a string naming the model (see \link{glm_families}) or a \code{tfp$glm$ExponentialFamily-like}
instance which implicitly characterizes a negative log-likelihood loss by specifying
the distribuion's mean, gradient_mean, and variance.}

\item{model_coefficients_start}{Optional (batch of) vector-shaped Tensor representing
the initial model coefficients, one for each column in \code{x}. Must have same \code{dtype}
as model_matrix. Default value: Zeros.}

\item{predicted_linear_response_start}{Optional Tensor with shape, \code{dtype} matching
\code{response}; represents offset shifted initial linear predictions based on
\code{model_coefficients_start}. Default value: offset if model_coefficients is \code{NULL},
and \code{tf$linalg$matvec(x, model_coefficients_start) + offset} otherwise.}

\item{l2_regularizer}{Optional scalar Tensor representing L2 regularization penalty.
Default: \code{NULL} ie. no regularization.}

\item{dispersion}{Optional (batch of) Tensor representing response dispersion.}

\item{offset}{Optional Tensor representing constant shift applied to \code{predicted_linear_response}.}

\item{convergence_criteria_fn}{callable taking: \code{is_converged_previous}, \code{iter_},
\code{model_coefficients_previous}, \code{predicted_linear_response_previous}, \code{model_coefficients_next},
\code{predicted_linear_response_next}, \code{response}, \code{model}, \code{dispersion} and returning
a logical Tensor indicating that Fisher scoring has converged.}

\item{learning_rate}{Optional (batch of) scalar Tensor used to dampen iterative progress.
Typically only needed if optimization diverges, should be no larger than 1 and typically
very close to 1. Default value: \code{NULL} (i.e., 1).}

\item{fast_unsafe_numerics}{Optional Python bool indicating if faster, less numerically
accurate methods can be employed for computing the weighted least-squares solution. Default
value: TRUE (i.e., "fast but possibly diminished accuracy").}

\item{maximum_iterations}{Optional maximum number of iterations of Fisher scoring to run;
"and-ed" with result of \code{convergence_criteria_fn}. Default value: \code{NULL} (i.e., infinity).}

\item{name}{usesed as name prefix to ops created by this function. Default value: "fit".}

\item{...}{other arguments passed to specific methods.}
}
\value{
A \code{glm_fit} object with parameter estimates, and
number of required steps.
}
\description{
Runs multiple Fisher scoring steps
}
\seealso{
Other glm_fit: \code{\link{glm_families}},
  \code{\link{glm_fit_one_step.tensorflow.tensor}}
}
\concept{glm_fit}
