% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sts.R
\name{sts_smooth_seasonal}
\alias{sts_smooth_seasonal}
\title{Formal representation of a smooth seasonal effect model}
\usage{
sts_smooth_seasonal(
  period,
  frequency_multipliers,
  allow_drift = TRUE,
  drift_scale_prior = NULL,
  initial_state_prior = NULL,
  observed_time_series = NULL,
  name = NULL
)
}
\arguments{
\item{period}{positive scalar \code{float} \code{Tensor} giving the number of timesteps
required for the longest cyclic effect to repeat.}

\item{frequency_multipliers}{One-dimensional \code{float} \code{Tensor} listing the
frequencies (cyclic components) included in the model, as multipliers of
the base/fundamental frequency \code{2. * pi / period}. Each component is
specified by the number of times it repeats per period, and adds two
latent dimensions to the model. A smooth seasonal model that can
represent any periodic function is given by
\verb{frequency_multipliers = [1,2, ..., floor(period / 2)]}.
However, it is often desirable to enforce a
smoothness assumption (and reduce the computational burden) by dropping
some of the higher frequencies.}

\item{allow_drift}{optional \code{logical} specifying whether the seasonal
effects can drift over time.  Setting this to \code{FALSE}
removes the \code{drift_scale} parameter from the model. This is
mathematically equivalent to
\code{drift_scale_prior = tfd.Deterministic(0.)}, but removing drift
directly is preferred because it avoids the use of a degenerate prior.
Default value: \code{TRUE}.}

\item{drift_scale_prior}{optional \code{tfd$Distribution} instance specifying a prior
on the \code{drift_scale} parameter. If \code{NULL}, a heuristic default prior is
constructed based on the provided \code{observed_time_series}.
Default value: \code{NULL}.}

\item{initial_state_prior}{instance of \code{tfd$MultivariateNormal} representing
the prior distribution on the latent states. Must have event shape
\verb{[2 * len(frequency_multipliers)]}. If \code{NULL}, a heuristic default prior
is constructed based on the provided \code{observed_time_series}.}

\item{observed_time_series}{optional \code{float} \code{Tensor} of shape
\verb{batch_shape + [T, 1]} (omitting the trailing unit dimension is also
supported when \code{T > 1}), specifying an observed time series.
Any priors not explicitly set will be given default values according to
the scale of the observed time series (or batch of time series). May
optionally be an instance of \code{tfp$sts$MaskedTimeSeries}, which includes
a mask \code{Tensor} to specify timesteps with missing observations.
Default value: \code{NULL}.}

\item{name}{the name of this model component. Default value: 'LocalLinearTrend'.}
}
\value{
an instance of \code{StructuralTimeSeries}.
}
\description{
The smooth seasonal model uses a set of trigonometric terms in order to
capture a recurring pattern whereby adjacent (in time) effects are
similar. The model uses \code{frequencies} calculated via:
}
\details{
\if{html}{\out{<div class="sourceCode">}}\preformatted{frequencies[j] = 2. * pi * frequency_multipliers[j] / period
}\if{html}{\out{</div>}}

and then posits two latent states for each \code{frequency}. The two latent states
associated with frequency \code{j} drift over time via:

\if{html}{\out{<div class="sourceCode">}}\preformatted{effect[t] = (effect[t-1] * cos(frequencies[j]) +
             auxiliary[t-] * sin(frequencies[j]) +
             Normal(0., drift_scale))
auxiliary[t] = (-effect[t-1] * sin(frequencies[j]) +
                auxiliary[t-] * cos(frequencies[j]) +
                Normal(0., drift_scale))
}\if{html}{\out{</div>}}

where \code{effect} is the smooth seasonal effect and \code{auxiliary} only appears as a
matter of construction. The interpretation of \code{auxiliary} is thus not
particularly important.
}
\seealso{
For usage examples see \code{\link[=sts_fit_with_hmc]{sts_fit_with_hmc()}}, \code{\link[=sts_forecast]{sts_forecast()}}, \code{\link[=sts_decompose_by_component]{sts_decompose_by_component()}}.

Other sts: 
\code{\link{sts_additive_state_space_model}()},
\code{\link{sts_autoregressive_state_space_model}()},
\code{\link{sts_autoregressive}()},
\code{\link{sts_constrained_seasonal_state_space_model}()},
\code{\link{sts_dynamic_linear_regression_state_space_model}()},
\code{\link{sts_dynamic_linear_regression}()},
\code{\link{sts_linear_regression}()},
\code{\link{sts_local_level_state_space_model}()},
\code{\link{sts_local_level}()},
\code{\link{sts_local_linear_trend_state_space_model}()},
\code{\link{sts_local_linear_trend}()},
\code{\link{sts_seasonal_state_space_model}()},
\code{\link{sts_seasonal}()},
\code{\link{sts_semi_local_linear_trend_state_space_model}()},
\code{\link{sts_semi_local_linear_trend}()},
\code{\link{sts_smooth_seasonal_state_space_model}()},
\code{\link{sts_sparse_linear_regression}()},
\code{\link{sts_sum}()}
}
\concept{sts}
