% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/split_portion.R
\name{split_portion}
\alias{split_portion}
\title{Break Text Into Ordered Word Chunks}
\usage{
split_portion(text.var, grouping.var = NULL, n.words, n.chunks,
  as.string = TRUE, rm.unequal = FALSE, as.table = TRUE, ...)
}
\arguments{
\item{text.var}{The text variable}

\item{grouping.var}{The grouping variables.  Default \code{NULL} generates
one word list for all text.  Also takes a single grouping variable or a list
of 1 or more grouping variables.}

\item{n.words}{An integer specifying the number of words in each chunk (must
specify n.chunks or n.words).}

\item{n.chunks}{An integer specifying the number of chunks (must specify
n.chunks or n.words).}

\item{as.string}{logical.  If \code{TRUE} the chunks are returned as a single
string.  If \code{FALSE} the chunks are returned as a vector of single words.}

\item{rm.unequal}{logical. If \code{TRUE} final chunks that are unequal in
length to the other chunks are removed.}

\item{as.table}{logical.  If \code{TRUE} the list output is coerced to
\code{\link[data.table]{data.table}} or \pkg{tibble}.}

\item{\ldots}{Ignored.}
}
\value{
Returns a list or \code{\link[data.table]{data.table}} of text chunks.
}
\description{
Some visualizations and algorithms require text to be broken into chunks of
ordered words.  \code{split_portion} breaks text, optionally by grouping
variables, into equal chunks.  The chunk size can be specified by giving
number of words to be in each chunk or the number of chunks.
}
\examples{
with(DATA, split_portion(state, n.chunks = 10))
with(DATA, split_portion(state, n.words = 10))
with(DATA, split_portion(state, n.chunks = 10, as.string=FALSE))
with(DATA, split_portion(state, n.chunks = 10, rm.unequal=TRUE))
with(DATA, split_portion(state, person, n.chunks = 10))
with(DATA, split_portion(state, list(sex, adult), n.words = 10))
with(DATA, split_portion(state, person, n.words = 10, rm.unequal=TRUE))

## Bigger data
with(hamlet, split_portion(dialogue, person, n.chunks = 10))
with(hamlet, split_portion(dialogue, list(act, scene, person), n.chunks = 10))
with(hamlet, split_portion(dialogue, person, n.words = 300))
with(hamlet, split_portion(dialogue, list(act, scene, person), n.words = 300))
}
\keyword{chunks}
\keyword{group}
\keyword{text}

