% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/split_sentence.R
\name{split_sentence}
\alias{split_sentence}
\alias{split_sentence.data.frame}
\alias{split_sentence.default}
\title{Split Sentences}
\usage{
split_sentence(x, ...)

\method{split_sentence}{default}(x, ...)

\method{split_sentence}{data.frame}(x, text.var = TRUE,
  as.tibble = tibble_output(), ...)
}
\arguments{
\item{x}{A \code{\link[base]{data.frame}} or character vector with sentences.}

\item{text.var}{The name of the text variable.  If \code{TRUE}
\code{split_sentence} tries to detect the column with sentences.}

\item{as.tibble}{logical.  If \code{TRUE} the output class will be set to a
\pkg{tibble}, otherwise a \code{\link[data.table]{data.table}}.  Default
checks \code{getOption("tibble.out")} as a logical.  If this is \code{NULL}
the default \code{\link[textshape]{tibble_output}} will set \code{as.tibble}
to \code{TRUE} if \pkg{dplyr} is loaded.  Otherwise, the output will be a
\code{\link[data.table]{data.table}}.}

\item{\ldots}{Ignored.}
}
\value{
Returns a list of vectors of sentences or a expanded
\code{\link[base]{data.frame}} with sentences split apart.
}
\description{
Split sentences.
}
\examples{
(x <- paste0(
    "Mr. Brown comes! He says hello. i give him coffee.  i will ",
    "go at 5 p. m. eastern time.  Or somewhere in between!go there"
))
split_sentence(x)

data(DATA)
split_sentence(DATA)
}

