% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidy_dtm.R
\name{tidy_dtm}
\alias{tidy_dtm}
\alias{tidy_tdm}
\title{Convert a \code{\link[tm]{DocumentTermMatrix}}/\code{\link[tm]{TermDocumentMatrix}}
into Tidy Form}
\usage{
tidy_dtm(x, ...)

tidy_tdm(x, ...)
}
\arguments{
\item{x}{A \code{\link[tm]{DocumentTermMatrix}}/\code{\link[tm]{TermDocumentMatrix}}.}

\item{\ldots}{ignored.}
}
\value{
Returns a tidied data.frame.
}
\description{
Converts non-zero elements of a
\code{\link[tm]{DocumentTermMatrix}}/\code{\link[tm]{TermDocumentMatrix}} into
a tidy data set.
}
\examples{
data(simple_dtm)

tidy_dtm(simple_dtm)

\dontrun{
if (!require("pacman")) install.packages("pacman")
pacman::p_load_current_gh('trinker/gofastr')
pacman::p_load(tidyverse, magrittr, ggstance)

my_dtm <- with(presidential_debates_2012, q_dtm(dialogue, paste(time, tot, sep = "_")))

tidy_dtm(my_dtm) \%>\%
    tidyr::extract(doc, c("time", "turn", "sentence"), "(\\\\d)_(\\\\d+)\\\\.(\\\\d+)") \%>\%
    mutate(
        time = as.numeric(time),
        turn = as.numeric(turn),
        sentence = as.numeric(sentence)
    ) \%>\%
    tbl_df() \%T>\%
    print() \%>\%
    group_by(time, term) \%>\%
    summarize(n = sum(n)) \%>\%
    group_by(time) \%>\%
    arrange(desc(n)) \%>\%
    slice(1:10) \%>\%
    mutate(
        term = factor(paste(term, time, sep = "__"),
            levels = rev(paste(term, time, sep = "__")))
    ) \%>\%
    ggplot(aes(x = n, y = term)) +
        geom_barh(stat='identity') +
        facet_wrap(~time, ncol=2, scales = 'free_y') +
        scale_y_discrete(labels = function(x) gsub("__.+$", "", x))
}
}

