% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sequence_onehot.R
\name{step_sequence_onehot}
\alias{step_sequence_onehot}
\alias{tidy.step_sequence_onehot}
\title{Generate the basic set of text features}
\source{
\url{https://papers.nips.cc/paper/5782-character-level-convolutional-networks-for-text-classification.pdf}
}
\usage{
step_sequence_onehot(
  recipe,
  ...,
  role = "predictor",
  trained = FALSE,
  columns = NULL,
  string_length = 100,
  integer_key = letters,
  prefix = "seq1hot",
  skip = FALSE,
  id = rand_id("sequence_onehot")
)

\method{tidy}{step_sequence_onehot}(x, ...)
}
\arguments{
\item{recipe}{A recipe object. The step will be added to the
sequence of operations for this recipe.}

\item{...}{One or more selector functions to choose variables.
For `step_sequence_onehot`, this indicates the variables to be encoded
into a list column. See [recipes::selections()] for more
details. For the `tidy` method, these are not currently used.}

\item{role}{For model terms created by this step, what analysis
role should they be assigned?. By default, the function assumes
that the new columns created by the original variables will be 
used as predictors in a model.}

\item{trained}{A logical to indicate if the recipe has been
baked.}

\item{columns}{A list of tibble results that define the
encoding. This is `NULL` until the step is trained by
[recipes::prep.recipe()].}

\item{string_length}{A numeric, number of characters to keep before 
discarding. Defaults to 100.}

\item{integer_key}{A character vector, characters to be mapped to integers. 
Characters not in the integer_key will be encoded as 0. Defaults to 
`letters`.}

\item{prefix}{A prefix for generated column names, default to "seq1hot".}

\item{skip}{A logical. Should the step be skipped when the
recipe is baked by [recipes::bake.recipe()]? While all
operations are baked when [recipes::prep.recipe()] is run, some
operations may not be able to be conducted on new data (e.g.
processing the outcome variable(s)). Care should be taken when
using `skip = TRUE` as it may affect the computations for
subsequent operations.}

\item{id}{A character string that is unique to this step to identify it}

\item{x}{A `step_sequence_onehot` object.}
}
\value{
An updated version of `recipe` with the new step added
 to the sequence of existing steps (if any).
}
\description{
`step_sequence_onehot` creates a *specification* of a recipe step that
 will take a string and do one hot encoding for each character by position.
}
\details{
The string will be capped by the string_length argument, strings shorter then 
string_length will be padded with empty characters. The encoding will assign 
a integer to each character in the integer_key, and will encode accordingly. 
Characters not in the integer_key will be encoded as 0.
}
\examples{
library(recipes)

data(okc_text)

okc_rec <- recipe(~ ., data = okc_text) \%>\%
  step_sequence_onehot(essay0) 
  
okc_obj <- okc_rec \%>\%
  prep(training = okc_text, retain = TRUE)

juice(okc_obj)
  
tidy(okc_rec, number = 1)
tidy(okc_obj, number = 1)

}
