% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Cluster2TopicModel.R
\name{Cluster2TopicModel}
\alias{Cluster2TopicModel}
\title{Represent a document clustering as a topic model}
\usage{
Cluster2TopicModel(dtm, clustering, ...)
}
\arguments{
\item{dtm}{A document term matrix of class \code{dgCMatrix} or whose class 
inherits from the \code{Matrix} package. Columns must index terms, rows must 
index documents.}

\item{clustering}{A vector of length \code{nrow(dtm)} whose entries form a
partitional clustering of the documents.}

\item{...}{Other arguments to be passed to \code{\link[textmineR]{TmParallelApply}}.}
}
\value{
Returns a list with two elements, phi and theta. 'phi' is a matrix 
whose j-th row represents P(terms | cluster_j). 'theta' is a matrix whose
j-th row represents P(clusters | document_j). Each row of theta should only
have one non-zero element.
}
\description{
Represents a document clustering as a topic model of two matrices.
phi: P(term | cluster) theta: P(cluster | document)
}
\examples{
\dontrun{
# Load pre-formatted data for use
data(nih_sample_dtm)
data(nih_sample) 

result <- Cluster2TopicModel(dtm = nih_sample_dtm, 
                             clustering = nih_sample$IC_NAME)
}
}
