% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GetProbableTerms.R
\name{GetProbableTerms}
\alias{GetProbableTerms}
\title{Get cluster labels using a "more probable" method of terms}
\usage{
GetProbableTerms(docnames, dtm, p.terms = NULL)
}
\arguments{
\item{docnames}{A character vector of rownames of dtm for set of documents}

\item{dtm}{A document term matrix of class \code{matrix} or \code{dgCMatrix}.}

\item{p.terms}{If not NULL (the default), a numeric vector representing the 
probabiliy of each term in the corpus whose names correspond to colnames(dtm).}
}
\value{
Returns a numeric vector of the format p.terms. The entries of the vectors 
correspond to the difference in the probability of drawing a term from the 
set of documents given by docnames and the probability of drawing that term 
from the corpus overall (p.terms).
}
\description{
Function extracts probable terms from a set of documents. 
Probable here implies more probable than in a corpus overall.
}
\examples{
# Load a pre-formatted dtm and topic model
data(acq2) 

# documents with a topic proportion of .25 or higher for topic 2
mydocs <- rownames(model$theta)[ model$theta[ , 2 ] >= 0.25 ] 

term.probs <- Matrix::colSums(dtm) / sum(Matrix::colSums(dtm))

GetProbableTerms(docnames=mydocs, dtm=dtm, p.terms=term.probs)

}

