% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_row.R
\name{filter_row}
\alias{filter_row}
\alias{filter_empty_row}
\alias{filter_NA}
\title{Remove Rows That Contain Markers}
\usage{
filter_row(dataframe, column, terms, ...)

filter_empty_row(dataframe)

filter_NA(dataframe, column = TRUE, ...)
}
\arguments{
\item{dataframe}{A dataframe object.}

\item{column}{Column name to search for markers/terms.}

\item{terms}{The regex terms/markers of the rows that are to be removed from 
the dataframe.}

\item{\ldots}{Other arguments passed to \code{\link[base]{grepl}}.}
}
\value{
\code{filter_row} - returns a dataframe with the termed/markered rows 
removed.

\code{filter_empty_row} - returns a dataframe with empty rows removed.

\code{filter_NA} - returns a dataframe with \code{NA} rows removed.
}
\description{
\code{filter_row} - Remove rows from a data set that contain a given marker/term.

\code{filter_empty_row} - Removes the empty rows of a data set that are common in 
reading in data.

\code{filter_NA} - Removes the \code{NA} rows of a data set.
}
\examples{
\dontrun{
## filter_row EXAMPLE:
filter_row(DATA, "person", c("sam", "greg"))
filter_row(DATA, 1, c("sam", "greg"))
filter_row(DATA, "state", c("Comp"))
filter_row(DATA, "state", c("I "))
filter_row(DATA, "state", c("you"), ignore.case=TRUE)

## filter_empty_row EXAMPLE:
(dat <- rbind.data.frame(DATA[, c(1, 4)], matrix(rep(" ", 4), 
   ncol =2, dimnames=list(12:13, colnames(DATA)[c(1, 4)]))))
filter_empty_row(dat)

## filter_NA EXAMPLE:
DATA[1:3, "state"] <- NA
filter_NA(DATA)
}
}
