% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{TEXT_DOC_DISSIM}
\alias{TEXT_DOC_DISSIM}
\title{Dissimilarity calculation of text documents}
\usage{
TEXT_DOC_DISSIM(
  first_matr = NULL,
  second_matr = NULL,
  method = "euclidean",
  batches = NULL,
  threads = 1,
  verbose = FALSE
)
}
\arguments{
\item{first_matr}{a numeric matrix where each row represents a text document ( has same dimensions as the \emph{second_matr} )}

\item{second_matr}{a numeric matrix where each row represents a text document ( has same dimensions as the \emph{first_matr} )}

\item{method}{a dissimilarity metric in form of a character string. One of \emph{euclidean}, \emph{manhattan}, \emph{chebyshev}, \emph{canberra}, \emph{braycurtis}, \emph{pearson_correlation}, \emph{cosine},
\emph{simple_matching_coefficient}, \emph{hamming}, \emph{jaccard_coefficient}, \emph{Rao_coefficient}}

\item{batches}{a numeric value specifying the number of batches}

\item{threads}{a numeric value specifying the number of cores to run in parallel}

\item{verbose}{either TRUE or FALSE. If TRUE then information will be printed in the console}
}
\value{
a numeric vector
}
\description{
Dissimilarity calculation of text documents
}
\details{
Row-wise dissimilarity calculation of text documents. The text document sequences should be converted to numeric matrices using for instance LSI (Latent Semantic Indexing).
If the numeric matrices are too big to be pre-processed, then one should use the \emph{batches} parameter to split the data in batches before applying one of the dissimilarity metrics.
For parallelization (\emph{threads}) OpenMP will be used.
}
\examples{

\dontrun{

library(textTinyR)


# example input LSI matrices (see details section)
#-------------------------------------------------

set.seed(1)
LSI_matrix1 = matrix(runif(10000), 100, 100)

set.seed(2)
LSI_matrix2 = matrix(runif(10000), 100, 100)


txt_out = TEXT_DOC_DISSIM(first_matr = LSI_matrix1,

                          second_matr = LSI_matrix2, 'euclidean')
}
}
