[![cran version](http://www.r-pkg.org/badges/version/text2sdg)](https://CRAN.R-project.org/package=text2sdg)
[![DOI](https://zenodo.org/badge/DOI/10.5281/zenodo.5553980.svg)](https://doi.org/10.5281/zenodo.5553980)
[![downloads](https://cranlogs.r-pkg.org/badges/grand-total/text2sdg?color=yellow)](https://CRAN.R-project.org/package=text2sdg)

# text2sdg <img src="man/figures/logo.png" align="right" alt="" width="120" />

The United Nations’ Sustainable Development Goals (SDGs) have become an important guideline for higher-education and research institutions to monitor and plan their contributions to social, economic, and environmental transformations.

The `text2sdg` package is the first open-source, multi-system analysis package that identifies SDGs in text, opening up the opportunity to monitor any type of text-based data, including scientific output and corporate publications.


## General Information

The `text2sdg` package is developed by Dirk U. Wulff and Dominik S. Meier, with contributions from Rui Mata and the <a href="https://cds.unibas.ch/">Center for Cognitive and Decision Sciences</a>. It is published under the GNU General Public License.

An overview of the package can be accessed
[online](https://www.text2sdg.io/reference/text2sdg.html) or from within R using `?text2sdg`. A tutorial illustrating the use of the package can be accessed
[online]( https://www.text2sdg.io/articles/text2sdg.html) or from within R using `vignette("text2sdg")`.

# Installation

The current stable version is available on CRAN and can be installed via `install.packages("text2sdg")`.

The latest development version on GitHub can be installed via `devtools::install_github("dwulff/text2sdg")`. Note that this requires prior installation of the `devtools` package.  

## Citation

If you publish analyzes carried out using the `text2sdg` package, we kindly ask that you cite the package as follows:

Wulff, Dirk U. & Meier, Dominik S. (2021). text2sdg: Detecting UN Sustainable Development Goals in Text (0.1.0). Zenodo. https://doi.org/10.5281/zenodo.5553980
