% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/texreg.R
\name{get_stars_note}
\alias{get_stars_note}
\title{Create a legend for the stars in a regression table}
\usage{
get_stars_note(
  stars = c(0.01, 0.05, 0.1),
  star.symbol = "*",
  symbol = ".",
  ci = FALSE,
  ci.test = NULL,
  output = "ascii"
)
}
\arguments{
\item{stars}{A numeric vector of cut-offs, with a maximum of four numbers.}

\item{star.symbol}{The character to repeat for the first three levels of
significance.}

\item{symbol}{The character for the fourth level of significance.}

\item{ci}{Confidence intervals instead of standard errors?}

\item{ci.test}{The null hypothesis value, for example \code{0} (the normal
case) or \code{1} (e.g., with exponentiated coefficients). A star is added
if this value is outside the confidence interval.}

\item{output}{The output type of the note. This can be \code{"ascii"},
\code{"latex"}, or \code{"html"}.}
}
\value{
A \code{character} string to be put below the regression table. It
  describes the thresholds for the significance stars.
}
\description{
Create a legend for the stars in a regression table.
}
\details{
This function creates a stars note as a legend to be placed below a
regression table. The note contains the p-value or confidence interval
significance levels and stars attached to them.
}
\seealso{
\code{\link{texreg}}, \code{\link{htmlreg}}, \code{\link{screenreg}}
}
\author{
Philip Leifeld
}
\keyword{internal}
