% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract.R
\name{extract,stergm-method}
\alias{extract,stergm-method}
\alias{extract.stergm}
\title{\code{\link{extract}} method for \code{stergm} objects}
\usage{
\S4method{extract}{stergm}(
  model,
  beside = FALSE,
  include.formation = TRUE,
  include.dissolution = TRUE,
  include.nvertices = TRUE,
  include.aic = FALSE,
  include.bic = FALSE,
  include.loglik = FALSE,
  ...
)
}
\arguments{
\item{model}{A statistical model object.}

\item{beside}{Arrange the model terms below each other or beside each other?
In a \code{stergm} model, the formation and dissolution coefficients can be
arranged in two columns of the table.}

\item{include.formation}{Report the coefficients for the formation process in
a STERGM?}

\item{include.dissolution}{Report the coefficients for the dissolution
process in a STERGM?}

\item{include.nvertices}{Report the number of vertices in a STERGM?}

\item{include.aic}{Report Akaike's Information Criterion (AIC) in the GOF
block?}

\item{include.bic}{Report the Bayesian Information Criterion (BIC) in the GOF
block?}

\item{include.loglik}{Report the log likelihood in the GOF block?}

\item{...}{Custom parameters, which are handed over to subroutines, in this
case to the \code{summary} method for the object.}
}
\description{
\code{\link{extract}} method for \code{stergm} objects created by the
\code{\link[tergm]{stergm}} function in the \pkg{tergm} package.
}
