% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract.R
\name{extract,glmmTMB-method}
\alias{extract,glmmTMB-method}
\alias{extract.glmmTMB}
\title{\code{\link{extract}} method for \code{glmmTMB} objects}
\usage{
\S4method{extract}{glmmTMB}(
  model,
  beside = FALSE,
  include.count = TRUE,
  include.zero = TRUE,
  include.aic = TRUE,
  include.groups = TRUE,
  include.variance = TRUE,
  include.loglik = TRUE,
  include.nobs = TRUE,
  ...
)
}
\arguments{
\item{model}{A statistical model object.}

\item{beside}{Arrange the model terms below each other or beside each other?
The binary model parameters and the count parameters can be displayed in
two separate columns of the table.}

\item{include.count}{Report the count parameters in the coefficients block
(before the binary part for the zeros)?}

\item{include.zero}{Should the binary part of the model be included in the
coefficients block (after the count parameters)?}

\item{include.aic}{Report Akaike's Information Criterion (AIC) in the GOF
block?}

\item{include.groups}{Report the number of groups?}

\item{include.variance}{Report group variances?}

\item{include.loglik}{Report the log likelihood in the GOF block?}

\item{include.nobs}{Report the number of observations in the GOF block?}

\item{...}{Custom parameters, which are handed over to subroutines, in this
case to the \code{summary} method for the object.}
}
\description{
\code{\link{extract}} method for \code{glmmTMB} objects created by the
\code{\link[glmmTMB]{glmmTMB}} function in the \pkg{glmmTMB} package.
}
\author{
Ricardo Graiff Garcia, Philip Leifeld
}
