% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat-tools.R
\name{count_inline}
\alias{count_inline}
\title{count inline elements}
\usage{
count_inline(article_dir, inline)
}
\arguments{
\item{article_dir}{path to the directory which contains RJ article}

\item{inline}{name of the inline element}
}
\value{
count of the inline element
}
\description{
counts inline elements embedded within the latex file
currently supported inlines : math (based on $$), code (based on \\code)
and Citations (based on \\cite,\\citealp, \\citep, \\citet)
}
\examples{
article_dir <- system.file("examples/article",
                 package = "texor")
math <- texor::count_inline(article_dir, "math")
code <- texor::count_inline(article_dir, "inlinecode")
cite <- texor::count_inline(article_dir, "cite")
print(paste("math inlines : ", math, "\n",
            "code inlines : ", code, "\n",
            "citations    : ", cite))
}
