% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/texPreview-deprecated.R
\name{texPreview}
\alias{texPreview}
\title{Render and Preview snippets of TeX in R Viewer \lifecycle{deprecated}}
\usage{
texPreview(obj, tex_lines = NULL, stem = "tex_temp",
  overwrite = TRUE, keep_pdf = FALSE, tex_message = FALSE,
  fileDir = tex_opts$get("fileDir"), margin = tex_opts$get("margin"),
  imgFormat = tex_opts$get("imgFormat"),
  returnType = tex_opts$get("returnType"),
  resizebox = tex_opts$get("resizebox"),
  usrPackages = tex_opts$get("usrPackages"),
  engine = tex_opts$get("engine"), cleanup = tex_opts$get("cleanup"),
  density = tex_opts$get("density"), svg_max = tex_opts$get("svg_max"),
  print.xtable.opts = tex_opts$get("print.xtable.opts"),
  opts.html = tex_opts$get("opts.html"), markers = interactive(), ...)
}
\arguments{
\item{obj}{object to convert to TeX script}

\item{tex_lines}{vector of character, in case of special needs, instead of
asking texPreview to build up, you may choose to pass in the contents of the
complete LaTeX file directly. It should be a vector of character with each
element as a line of raw TeX code.}

\item{stem}{character, name to use in output files, Default: "tex_temp"}

\item{overwrite}{logical, controls if overwriting of output
stem* files given their existences, Default: TRUE}

\item{keep_pdf}{logical, controls if the rendered pdf file should be kept
or deleted, Default: FALSE}

\item{tex_message}{logical, controls if latex executing messages
are displayed in console. Default: FALSE}

\item{fileDir}{character, output destination. If NULL a temp.dir()
will be used and no output will be saved, Default: tex_opts$get('fileDir')}

\item{margin}{table margin for pdflatex call, Default: tex_opts$get('margin')}

\item{imgFormat}{character, defines the type of image the PDF is
converted to Default: tex_opts$get('imgFormat')}

\item{returnType}{character, one of "viewer", "html", or "tex"
determining appropriate return type for the rendering process,
Default: tex_opts$get('returnType')}

\item{resizebox}{logical, forces a tabular tex object to be constrained on the
margins of the document, Default: tex_opts$get('resizebox')}

\item{usrPackages}{character, vector of usepackage commands,
see details for string format}

\item{engine}{character, specifies which latex to pdf engine to use
('pdflatex','xelatex','lualatex'), Default: tex_opts$get('engine')}

\item{cleanup}{character, vector of file extensions to clean up after
building pdf, Default: tex_opts$get('cleanup')}

\item{density}{numeric, controls the density of the image.
Default is 150: tex_opts$get('density)}

\item{svg_max}{numeric, maximum svg file size allowable to preview,
Default: tex_opts$get('svg_max')}

\item{print.xtable.opts}{list, contains arguments to pass to print.table,
relevant only if xtable is used as the input,
Default: tex_opts$get('print.xtable.opts')}

\item{opts.html}{list, html options, Default: tex_opts$get('opts.html')}

\item{markers}{logical, if TRUE then RStudio markers will be invoked to
create links for the log file on rendering errors, Default: interactive()}

\item{...}{passed to \link[base:system2]{system2}}
}
\description{
This function has been deprecated, use \link[texPreview:tex_preview]{tex_preview} instead.
}
