% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expect-setequal.R
\name{expect_setequal}
\alias{expect_setequal}
\alias{expect_mapequal}
\alias{expect_contains}
\alias{expect_in}
\alias{expect_disjoint}
\title{Do you expect a vector containing these values?}
\usage{
expect_setequal(object, expected)

expect_mapequal(object, expected)

expect_contains(object, expected)

expect_in(object, expected)

expect_disjoint(object, expected)
}
\arguments{
\item{object, expected}{Computation and value to compare it to.

Both arguments supports limited unquoting to make it easier to generate
readable failures within a function or for loop. See \link{quasi_label} for
more details.}
}
\description{
\itemize{
\item \code{expect_setequal(x, y)} tests that every element of \code{x} occurs in \code{y},
and that every element of \code{y} occurs in \code{x}.
\item \code{expect_contains(x, y)} tests that \code{x} contains every element of \code{y}
(i.e. \code{y} is a subset of \code{x}).
\item \code{expect_in(x, y)} tests that every element of \code{x} is in \code{y}
(i.e. \code{x} is a subset of \code{y}).
\item \code{expect_disjoint(x, y)} tests that no element of \code{x} is in \code{y}
(i.e. \code{x} is disjoint from \code{y}).
\item \code{expect_mapequal(x, y)} treats lists as if they are mappings between names
and values. Concretely, checks that \code{x} and \code{y} have the same names, then
checks that \code{x[names(y)]} equals \code{y}.
}
}
\details{
Note that \code{expect_setequal()} ignores names, and you will be warned if both
\code{object} and \code{expected} have them.
}
\examples{
expect_setequal(letters, rev(letters))
show_failure(expect_setequal(letters[-1], rev(letters)))

x <- list(b = 2, a = 1)
expect_mapequal(x, list(a = 1, b = 2))
show_failure(expect_mapequal(x, list(a = 1)))
show_failure(expect_mapequal(x, list(a = 1, b = "x")))
show_failure(expect_mapequal(x, list(a = 1, b = 2, c = 3)))
}
