% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test-package.R
\name{test_package}
\alias{test_package}
\alias{test_check}
\alias{test_local}
\title{Run all tests in a package}
\usage{
test_package(package, reporter = check_reporter(), ...)

test_check(package, reporter = check_reporter(), ...)

test_local(path = ".", reporter = NULL, ...)
}
\arguments{
\item{package}{If these tests belong to a package, the name of the package.}

\item{reporter}{Reporter to use to summarise output. Can be supplied
as a string (e.g. "summary") or as an R6 object
(e.g. \code{SummaryReporter$new()}).

See \link{Reporter} for more details and a list of built-in reporters.}

\item{...}{Additional arguments passed to \code{\link[=test_dir]{test_dir()}}}

\item{path}{Path to directory containing tests.}
}
\value{
A list (invisibly) containing data about the test results.
}
\description{
\itemize{
\item \code{test_local()} tests a local source package.
\item \code{test_package()} tests an installed package.
\item \code{test_check()} checks a package during \verb{R CMD check}.
}

Tests live in \code{tests/testthat}.
}
\section{\verb{R CMD check}}{

To run testthat automatically from \verb{R CMD check}, make sure you have
a \code{tests/testthat.R} that contains:\preformatted{library(testthat)
library(yourpackage)

test_check("yourpackage")
}
}

\section{Special files}{

There are two types of \code{.R} file that have special behaviour:
\itemize{
\item Test files start with \code{test} and are executed in alphabetical order.
\item Setup files start with \code{setup} and are executed before tests. If
clean up is needed after all tests have been run, you can use
\code{withr::defer(clean_up(), teardown_env())}. See \code{vignette("text-fixtures")}
for more details.
}

There are two other types of special file that we no longer recommend using:
\itemize{
\item Helper files start with \code{helper} and are executed before tests are
run. They're also loaded by \code{devtools::load_all()}, so there's no
real point to them and you should just put your helper code in \verb{R/}.
\item Teardown files start with \code{teardown} and are executed after the tests
are run. Now we recommend interleave setup and cleanup code in \verb{setup-}
files, making it easier to check that you automatically clean up every
mess that you make.
}

All other files are ignored by testthat.
}

\section{Environments}{

Each test is run in a clean environment to keep tests as isolated as
possible. For package tests, that environment that inherits from the
package's namespace environment, so that tests can access internal functions
and objects.
}

