% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare.R, R/compare-character.R,
%   R/compare-numeric.R, R/compare-time.R
\name{compare}
\alias{compare}
\alias{compare.default}
\alias{compare.character}
\alias{compare.numeric}
\alias{testthat_tolerance}
\alias{compare.POSIXt}
\title{Provide human-readable comparison of two objects}
\usage{
compare(x, y, ...)

\method{compare}{default}(x, y, ..., max_diffs = 9)

\method{compare}{character}(
  x,
  y,
  check.attributes = TRUE,
  ...,
  max_diffs = 5,
  max_lines = 5,
  width = cli::console_width()
)

\method{compare}{numeric}(
  x,
  y,
  tolerance = testthat_tolerance(),
  check.attributes = TRUE,
  ...,
  max_diffs = 9
)

testthat_tolerance(x)

\method{compare}{POSIXt}(x, y, tolerance = 0.001, ..., max_diffs = 9)
}
\arguments{
\item{x, y}{Objects to compare}

\item{...}{Additional arguments used to control specifics of comparison}

\item{max_diffs}{Maximum number of differences to show}

\item{check.attributes}{If \code{TRUE}, also checks values of attributes.}

\item{max_lines}{Maximum number of lines to show from each difference}

\item{width}{Width of output device}

\item{tolerance}{Numerical tolerance: any differences smaller than this
value will be ignored.

The default tolerance is \code{sqrt(.Machine$double.eps)}, unless long doubles
are not available, in which case the test is skipped.}
}
\description{
\code{compare} is similar to \code{\link[base:all.equal]{base::all.equal()}}, but shows
you examples of where the failures occured.
}
\examples{
# Character -----------------------------------------------------------------
x <- c("abc", "def", "jih")
compare(x, x)

y <- paste0(x, "y")
compare(x, y)

compare(letters, paste0(letters, "-"))

x <- "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Duis cursus
 tincidunt auctor. Vestibulum ac metus bibendum, facilisis nisi non, pulvinar
 dolor. Donec pretium iaculis nulla, ut interdum sapien ultricies a. "
y <- "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Duis cursus
 tincidunt auctor. Vestibulum ac metus1 bibendum, facilisis nisi non, pulvinar
 dolor. Donec pretium iaculis nulla, ut interdum sapien ultricies a. "
compare(x, y)
compare(c(x, x), c(y, y))

# Numeric -------------------------------------------------------------------

x <- y <- runif(100)
y[sample(100, 10)] <- 5
compare(x, y)

x <- y <- 1:10
x[5] <- NA
x[6] <- 6.5
compare(x, y)

# Compare ignores minor numeric differences in the same way
# as all.equal.
compare(x, x + 1e-9)
}
\keyword{internal}
