% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test-package.R
\name{test_package}
\alias{test_check}
\alias{test_package}
\title{Run all tests in an installed package.}
\usage{
test_package(package, filter = NULL, reporter = "summary", ...)

test_check(package, filter = NULL, reporter = "check", ...)
}
\arguments{
\item{package}{package name}

\item{filter}{If not \code{NULL}, only tests with file names matching this
regular expression will be executed.  Matching will take on the file
name after it has been stripped of \code{"test-"} and \code{".R"}.}

\item{reporter}{reporter to use}

\item{...}{Additional arguments passed to \code{grepl} to control filtering.}
}
\value{
the results as a "testthat_results" (list)
}
\description{
Test are run in an environment that inherits from the package's namespace
environment, so that tests can access non-exported functions and variables.
Tests should be placed in \code{tests/testthat}. Use \code{test_check} with
\code{R CMD check} and \code{test_package} interactively at the console.
}
\section{R CMD check}{

Create \code{tests/testthat.R} that contains:

\preformatted{
library(testthat)
library(yourpackage)

test_check("yourpackage")
}
}
\examples{
\dontrun{test_package("testthat")}
}

