% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/utils.r
\name{skip}
\alias{skip}
\alias{skip_if_not_installed}
\alias{skip_on_cran}
\alias{skip_on_travis}
\title{Skip a test.}
\usage{
skip(message)

skip_if_not_installed(pkg)

skip_on_cran()

skip_on_travis()
}
\arguments{
\item{message}{A message describing why the test was skipped.}

\item{pkg}{Name of package to check for}
}
\description{
This function allows you to skip a test if it's not currently available.
This will produce an informative message, but will not cause the test
suite to fail.
}
\section{Helpers}{

\code{skip_on_cran()} skips tests on CRAN, using the \code{NOT_CRAN}
environment variable set by devtools.

\code{skip_on_travis()} skips tests on travis by inspecting the
\code{TRAVIS} environment variable.

\code{skip_if_not_installed()} skips a tests if a package is not installed
(useful for suggested packages).
}
\examples{
if (FALSE) skip("No internet connection")
}

