% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/asymptoticTimings.R
\name{asymptoticTimings}
\alias{asymptoticTimings}
\title{Asymptotic Timings Quantifying function}
\usage{
asymptoticTimings(e, data.sizes, max.seconds)
}
\arguments{
\item{e}{An expression which is in the form of a function operating on 'N' (as the data size for the algorithm to be tested against for a run), which takes values from the used-supplied parameter data.sizes.}

\item{data.sizes}{A vector/set of data sizes, which should preferably be a sequence in powers of ten, with mid-values included.
Example: data.sizes = 10^seq(1, 4, by = 0.5)}

\item{max.seconds}{The maximum number of seconds an iteration would be limited upto. (once the limit has been exceeded, further computations on incrementally larger dataset sizes won't be done)
Optional, with the default value set to 1 second.}
}
\value{
A data frame comprising of the timings computed by microbenchmark and the corresponding dataset sizes.
}
\description{
Function to compute benchmarked timings with different data sizes for an R expression
}
\details{
For more information regarding its implementation or functionality/usage, please check https://anirban166.github.io//Timings-function/
}
\examples{
# Quantifying the runtimes for the quick sort algorithm (with sampling performed)
# against a set of increasing input data sizes:
input.sizes = 10^seq(1, 3, by = 0.5)
asymptoticTimings(sort(sample(1:100, data.sizes, replace = TRUE), method = "quick"), input.sizes)
}
