% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{cass}
\alias{cass}
\title{Coronary Artery Surgery Study data}
\format{
A data frame with 871 rows and 3 columns:
\describe{
  \item{exercise}{Dichotomous result on exercise stress testing.}
  \item{cp}{Presence of absence of chest pain based on medical history.}
  \item{angio}{Dichotomous result on coronary angiography.}
}
}
\source{
\doi{10.1056/NEJM197908023010502}
}
\usage{
cass
}
\description{
This data from the Coronary Artery Surgery Study evaluates two tests to
determine the presence or absence of coronary artery disease by comparing to
coronary angiography, the gold standard. Test 1 is an exercise stress test
and Test 2 is a clinical history of chest pain.
}
\details{
All three variables are dichotomous. 1 indicates a positive result;
0 indicates a negative result.

This data was originally presented in Weiner et al. (1979).
}
\references{
Weiner et al. (1979)) N Engl J Med. 1979;301(5):230-5
\doi{10.1056/NEJM197908023010502}
}
\keyword{datasets}
