% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat.R
\name{stat_mean_pval}
\alias{stat_mean_pval}
\title{p-Value of the mean}
\usage{
stat_mean_pval(x, na.rm = TRUE, n_min = 2, test_mean = 0)
}
\arguments{
\item{x}{(\code{numeric})\cr vector of numbers we want to analyze.}

\item{na.rm}{(\code{flag})\cr whether \code{NA} values should be removed from \code{x} prior to analysis.}

\item{n_min}{(\code{numeric(1)})\cr a minimum number of non-missing \code{x} to estimate the p-value of the mean.}

\item{test_mean}{(\code{numeric(1)})\cr mean value to test under the null hypothesis.}
}
\value{
A p-value.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Convenient function for calculating the two-sided p-value of the mean.
}
\examples{
stat_mean_pval(sample(10))

stat_mean_pval(rnorm(10), test_mean = 0.5)

}
