% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/h_biomarkers_subgroups.R
\name{h_tab_one_biomarker}
\alias{h_tab_one_biomarker}
\title{Helper function for tabulation of a single biomarker result}
\usage{
h_tab_one_biomarker(
  df,
  afuns,
  colvars,
  na_str = default_na_str(),
  .indent_mods = 0L,
  ...
)
}
\arguments{
\item{df}{(\code{data.frame})\cr results for a single biomarker.}

\item{afuns}{(named \code{list} of \code{function})\cr analysis functions.}

\item{colvars}{(named \code{list})\cr named list with elements \code{vars} (variables to tabulate) and \code{labels} (their labels).}

\item{na_str}{(\code{string})\cr string used to replace all \code{NA} or empty values in the output.}

\item{.indent_mods}{(named \code{integer})\cr indent modifiers for the labels. Defaults to 0, which corresponds to the
unmodified default behavior. Can be negative.}

\item{...}{additional arguments for the lower level functions.}
}
\value{
An \code{rtables} table object with statistics in columns.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Please see \code{\link[=h_tab_surv_one_biomarker]{h_tab_surv_one_biomarker()}} and \code{\link[=h_tab_rsp_one_biomarker]{h_tab_rsp_one_biomarker()}}, which use this function for examples.
This function is a wrapper for \code{\link[rtables:summarize_row_groups]{rtables::summarize_row_groups()}}.
}
