% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/g_waterfall.R
\name{g_waterfall}
\alias{g_waterfall}
\title{Horizontal waterfall plot}
\usage{
g_waterfall(
  height,
  id,
  col_var = NULL,
  col = getOption("ggplot2.discrete.colour"),
  xlab = NULL,
  ylab = NULL,
  col_legend_title = NULL,
  title = NULL
)
}
\arguments{
\item{height}{(\code{numeric})\cr vector containing values to be plotted as the waterfall bars.}

\item{id}{(\code{character})\cr vector containing identifiers to use as the x-axis label for the waterfall bars.}

\item{col_var}{(\code{factor}, \code{character}, or \code{NULL})\cr categorical variable for bar coloring. \code{NULL} by default.}

\item{col}{(\code{character})\cr color(s).}

\item{xlab}{(\code{string})\cr x label. Default is \code{"ID"}.}

\item{ylab}{(\code{string})\cr y label. Default is \code{"Value"}.}

\item{col_legend_title}{(\code{string})\cr text to be displayed as legend title.}

\item{title}{(\code{string})\cr text to be displayed as plot title.}
}
\value{
A \code{ggplot} waterfall plot.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

This basic waterfall plot visualizes a quantity \code{height} ordered by value with some markup.
}
\examples{
library(dplyr)
library(nestcolor)

g_waterfall(height = c(3, 5, -1), id = letters[1:3])

g_waterfall(
  height = c(3, 5, -1),
  id = letters[1:3],
  col_var = letters[1:3]
)

adsl_f <- tern_ex_adsl \%>\%
  select(USUBJID, STUDYID, ARM, ARMCD, SEX)

adrs_f <- tern_ex_adrs \%>\%
  filter(PARAMCD == "OVRINV") \%>\%
  mutate(pchg = rnorm(n(), 10, 50))

adrs_f <- head(adrs_f, 30)
adrs_f <- adrs_f[!duplicated(adrs_f$USUBJID), ]
head(adrs_f)

g_waterfall(
  height = adrs_f$pchg,
  id = adrs_f$USUBJID,
  col_var = adrs_f$AVALC
)

g_waterfall(
  height = adrs_f$pchg,
  id = paste("asdfdsfdsfsd", adrs_f$USUBJID),
  col_var = adrs_f$SEX
)

g_waterfall(
  height = adrs_f$pchg,
  id = paste("asdfdsfdsfsd", adrs_f$USUBJID),
  xlab = "ID",
  ylab = "Percentage Change",
  title = "Waterfall plot"
)

}
