% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formatting_functions.R
\name{format_auto}
\alias{format_auto}
\title{Format automatically using data significant digits}
\usage{
format_auto(dt_var, x_stat)
}
\arguments{
\item{dt_var}{(\code{numeric})\cr variable data the statistics were calculated from. Used only to
find significant digits. In \link{analyze_vars} this comes from \code{.df_row} (see
\link[rtables:additional_fun_params]{rtables::additional_fun_params}), and it is the row data after the above row splits. No
column split is considered.}

\item{x_stat}{(\code{string})\cr string indicating the current statistical method used.}
}
\value{
A string that \code{rtables} prints in a table cell.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Formatting function for the majority of default methods used in \code{\link[=analyze_vars]{analyze_vars()}}.
For non-derived values, the significant digits of data is used (e.g. range), while derived
values have one more digits (measure of location and dispersion like mean, standard deviation).
This function can be called internally with "auto" like, for example,
\code{.formats = c("mean" = "auto")}. See details to see how this works with the inner function.
}
\details{
The internal function is needed to work with \code{rtables} default structure for
format functions, i.e. \verb{function(x, ...)}, where is x are results from statistical evaluation.
It can be more than one element (e.g. for \code{.stats = "mean_sd"}).
}
\examples{
x_todo <- c(0.001, 0.2, 0.0011000, 3, 4)
res <- c(mean(x_todo[1:3]), sd(x_todo[1:3]))

# x is the result coming into the formatting function -> res!!
format_auto(dt_var = x_todo, x_stat = "mean_sd")(x = res)
format_auto(x_todo, "range")(x = range(x_todo))
no_sc_x <- c(0.0000001, 1)
format_auto(no_sc_x, "range")(x = no_sc_x)

}
\seealso{
Other formatting functions: 
\code{\link{extreme_format}},
\code{\link{format_count_fraction}()},
\code{\link{format_count_fraction_fixed_dp}()},
\code{\link{format_count_fraction_lt10}()},
\code{\link{format_extreme_values}()},
\code{\link{format_extreme_values_ci}()},
\code{\link{format_fraction}()},
\code{\link{format_fraction_fixed_dp}()},
\code{\link{format_fraction_threshold}()},
\code{\link{format_sigfig}()},
\code{\link{format_xx}()},
\code{\link{formatting_functions}}
}
\concept{formatting functions}
