% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/h_logistic_regression.R
\name{h_logistic_regression}
\alias{h_logistic_regression}
\alias{h_get_interaction_vars}
\alias{h_interaction_coef_name}
\alias{h_or_cat_interaction}
\alias{h_or_cont_interaction}
\alias{h_or_interaction}
\alias{h_simple_term_labels}
\alias{h_interaction_term_labels}
\alias{h_glm_simple_term_extract}
\alias{h_glm_interaction_extract}
\alias{h_glm_inter_term_extract}
\alias{h_logistic_simple_terms}
\alias{h_logistic_inter_terms}
\title{Helper Functions for Multivariate Logistic Regression}
\usage{
h_get_interaction_vars(fit_glm)

h_interaction_coef_name(
  interaction_vars,
  first_var_with_level,
  second_var_with_level
)

h_or_cat_interaction(
  odds_ratio_var,
  interaction_var,
  fit_glm,
  conf_level = 0.95
)

h_or_cont_interaction(
  odds_ratio_var,
  interaction_var,
  fit_glm,
  at = NULL,
  conf_level = 0.95
)

h_or_interaction(
  odds_ratio_var,
  interaction_var,
  fit_glm,
  at = NULL,
  conf_level = 0.95
)

h_simple_term_labels(terms, table)

h_interaction_term_labels(terms1, terms2, table, any = FALSE)

h_glm_simple_term_extract(x, fit_glm)

h_glm_interaction_extract(x, fit_glm)

h_glm_inter_term_extract(odds_ratio_var, interaction_var, fit_glm, ...)

h_logistic_simple_terms(x, fit_glm, conf_level = 0.95)

h_logistic_inter_terms(x, fit_glm, conf_level = 0.95, at = NULL)
}
\arguments{
\item{fit_glm}{(\code{glm})\cr logistic regression model fitted by \code{\link[stats:glm]{stats::glm()}} with "binomial" family.
Limited functionality is also available for conditional logistic regression models fitted by
\code{\link[survival:clogit]{survival::clogit()}}, currently this is used only by \code{\link[=extract_rsp_biomarkers]{extract_rsp_biomarkers()}}.}

\item{interaction_vars}{(\code{character} of length 2)\cr interaction variable names.}

\item{first_var_with_level}{(\code{character} of length 2)\cr the first variable name with
the interaction level.}

\item{second_var_with_level}{(\code{character} of length 2)\cr the second variable name with
the interaction level.}

\item{odds_ratio_var}{(\code{string})\cr the odds ratio variable.}

\item{interaction_var}{(\code{string})\cr the interaction variable.}

\item{conf_level}{(\code{proportion})\cr confidence level of the interval.}

\item{at}{(\code{NULL} or \code{numeric})\cr optional values for the interaction variable. Otherwise
the median is used.}

\item{terms}{(\code{character})\cr simple terms.}

\item{table}{(\code{table})\cr table containing numbers for terms.}

\item{terms1}{(\code{character})\cr terms for first dimension (rows).}

\item{terms2}{(\code{character})\cr terms for second dimension (rows).}

\item{any}{(\code{flag})\cr whether any of \code{term1} and \code{term2} can be fulfilled to count the
number of patients. In that case they can only be scalar (strings).}

\item{x}{(\code{string} or \code{character})\cr a variable or interaction term in \code{fit_glm} (depending on the
helper function).}

\item{...}{additional arguments for the lower level functions.}
}
\value{
Vector of names of interaction variables.

Name of coefficient.

Odds ratio.

Odds ratio.

Odds ratio.

Term labels containing numbers of patients.

Term labels containing numbers of patients.

Tabulated main effect results from a logistic regression model.

Tabulated interaction term results from a logistic regression model.

A \code{data.frame} of tabulated interaction term results from a logistic regression model.

Tabulated statistics for the given variable(s) from the logistic regression model.

Tabulated statistics for the given variable(s) from the logistic regression model.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Helper functions used in calculations for logistic regression.
}
\section{Functions}{
\itemize{
\item \code{h_get_interaction_vars()}: Helper function to extract interaction variable names from a fitted
model assuming only one interaction term.

\item \code{h_interaction_coef_name()}: Helper function to get the right coefficient name from the
interaction variable names and the given levels. The main value here is that the order
of first and second variable is checked in the \code{interaction_vars} input.

\item \code{h_or_cat_interaction()}: Helper function to calculate the odds ratio estimates
for the case when both the odds ratio and the interaction variable are categorical.

\item \code{h_or_cont_interaction()}: Helper function to calculate the odds ratio estimates
for the case when either the odds ratio or the interaction variable is continuous.

\item \code{h_or_interaction()}: Helper function to calculate the odds ratio estimates
in case of an interaction. This is a wrapper for \code{\link[=h_or_cont_interaction]{h_or_cont_interaction()}} and
\code{\link[=h_or_cat_interaction]{h_or_cat_interaction()}}.

\item \code{h_simple_term_labels()}: Helper function to construct term labels from simple terms and the table
of numbers of patients.

\item \code{h_interaction_term_labels()}: Helper function to construct term labels from interaction terms and the table
of numbers of patients.

\item \code{h_glm_simple_term_extract()}: Helper function to tabulate the main effect
results of a (conditional) logistic regression model.

\item \code{h_glm_interaction_extract()}: Helper function to tabulate the interaction term
results of a logistic regression model.

\item \code{h_glm_inter_term_extract()}: Helper function to tabulate the interaction
results of a logistic regression model. This basically is a wrapper for
\code{\link[=h_or_interaction]{h_or_interaction()}} and \code{\link[=h_glm_simple_term_extract]{h_glm_simple_term_extract()}} which puts the results
in the right data frame format.

\item \code{h_logistic_simple_terms()}: Helper function to tabulate the results including
odds ratios and confidence intervals of simple terms.

\item \code{h_logistic_inter_terms()}: Helper function to tabulate the results including
odds ratios and confidence intervals of interaction terms.

}}
\note{
We don't provide a function for the case when both variables are continuous because
this does not arise in this table, as the treatment arm variable will always be involved
and categorical.
}
\examples{
library(dplyr)
library(broom)

adrs_f <- tern_ex_adrs \%>\%
  filter(PARAMCD == "BESRSPI") \%>\%
  filter(RACE \%in\% c("ASIAN", "WHITE", "BLACK OR AFRICAN AMERICAN")) \%>\%
  mutate(
    Response = case_when(AVALC \%in\% c("PR", "CR") ~ 1, TRUE ~ 0),
    RACE = factor(RACE),
    SEX = factor(SEX)
  )
formatters::var_labels(adrs_f) <- c(formatters::var_labels(tern_ex_adrs), Response = "Response")
mod1 <- fit_logistic(
  data = adrs_f,
  variables = list(
    response = "Response",
    arm = "ARMCD",
    covariates = c("AGE", "RACE")
  )
)
mod2 <- fit_logistic(
  data = adrs_f,
  variables = list(
    response = "Response",
    arm = "ARMCD",
    covariates = c("AGE", "RACE"),
    interaction = "AGE"
  )
)

h_glm_simple_term_extract("AGE", mod1)
h_glm_simple_term_extract("ARMCD", mod1)

h_glm_interaction_extract("ARMCD:AGE", mod2)

h_glm_inter_term_extract("AGE", "ARMCD", mod2)

h_logistic_simple_terms("AGE", mod1)

h_logistic_inter_terms(c("RACE", "AGE", "ARMCD", "AGE:ARMCD"), mod2)

}
