% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logistic_regression.R
\name{fit_logistic}
\alias{fit_logistic}
\title{Fit for Logistic Regression}
\usage{
fit_logistic(
  data,
  variables = list(response = "Response", arm = "ARMCD", covariates = NULL, interaction =
    NULL, strata = NULL),
  response_definition = "response"
)
}
\arguments{
\item{data}{(\code{data.frame})\cr the data frame on which the model was fit.}

\item{variables}{(named \code{list} of \code{string})\cr list of additional analysis variables.}

\item{response_definition}{(\code{string})\cr the definition of what an event is in terms of \code{response}.
This will be used when fitting the (conditional) logistic regression model on the left hand
side of the formula.}
}
\value{
A fitted logistic regression model.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Fit a (conditional) logistic regression model.
}
\section{Model Specification}{


The \code{variables} list needs to include the following elements:
\itemize{
\item \code{arm}: Treatment arm variable name.
\item \code{response}: The response arm variable name. Usually this is a 0/1 variable.
\item \code{covariates}: This is either \code{NULL} (no covariates) or a character vector of covariate variable names.
\item \code{interaction}: This is either \code{NULL} (no interaction) or a string of a single covariate variable name already
included in \code{covariates}. Then the interaction with the treatment arm is included in the model.
}
}

\examples{
library(dplyr)

adrs_f <- tern_ex_adrs \%>\%
  filter(PARAMCD == "BESRSPI") \%>\%
  filter(RACE \%in\% c("ASIAN", "WHITE", "BLACK OR AFRICAN AMERICAN")) \%>\%
  mutate(
    Response = case_when(AVALC \%in\% c("PR", "CR") ~ 1, TRUE ~ 0),
    RACE = factor(RACE),
    SEX = factor(SEX)
  )
formatters::var_labels(adrs_f) <- c(formatters::var_labels(tern_ex_adrs), Response = "Response")
mod1 <- fit_logistic(
  data = adrs_f,
  variables = list(
    response = "Response",
    arm = "ARMCD",
    covariates = c("AGE", "RACE")
  )
)
mod2 <- fit_logistic(
  data = adrs_f,
  variables = list(
    response = "Response",
    arm = "ARMCD",
    covariates = c("AGE", "RACE"),
    interaction = "AGE"
  )
)

}
