% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coxph.R
\name{estimate_coef}
\alias{estimate_coef}
\title{Hazard Ratio Estimation in Interactions}
\usage{
estimate_coef(
  variable,
  given,
  lvl_var,
  lvl_given,
  coef,
  mmat,
  vcov,
  conf_level = 0.95
)
}
\arguments{
\item{variable, given}{Names of two variable in interaction. We seek the estimation of the levels of \code{variable}
given the levels of \code{given}.}

\item{lvl_var, lvl_given}{corresponding levels has given by \code{levels}.}

\item{coef}{Numeric of estimated coefficients.}

\item{mmat}{A name numeric filled with 0 used as template to obtain the design matrix.}

\item{vcov}{Variance-covariance matrix of underlying model.}

\item{conf_level}{Single numeric for the confidence level of estimate intervals.}
}
\value{
A list of matrix (one per level of variable) with rows corresponding to the combinations of
\code{variable} and \code{given}, with columns:
\itemize{
\item \code{coef_hat}: Estimation of the coefficient.
\item \code{coef_se}: Standard error of the estimation.
\item \code{hr}: Hazard ratio.
\item \verb{lcl, ucl}: Lower/upper confidence limit of the hazard ratio.
}
}
\description{
This function estimates the hazard ratios between arms when an interaction variable is given with
specific values.
}
\details{
Given the cox regression investigating the effect of Arm (A, B, C; reference A)
and Sex (F, M; reference Female). The model is abbreviated: y ~ Arm + Sex + Arm x Sex.
The cox regression estimates the coefficients along with a variance-covariance matrix for:
\itemize{
\item b1 (arm b), b2 (arm c)
\item b3 (sex m)
\item b4 (arm b: sex m), b5 (arm c: sex m)
}

Given that I want an estimation of the Hazard Ratio for arm C/sex M, the estimation
will be given in reference to arm A/Sex M by exp(b2 + b3 + b5)/ exp(b3) = exp(b2 + b5),
therefore the interaction coefficient is given by b2 + b5 while the standard error is obtained
as $1.96 * sqrt(Var b2 + Var b5 + 2 * covariance (b2,b5))$ for a confidence level of 0.95.
}
\examples{
library(dplyr)
library(survival)

ADSL <- tern_ex_adsl \%>\%
  filter(SEX \%in\% c("F", "M"))

adtte <- tern_ex_adtte \%>\% filter(PARAMCD == "PFS")
adtte$ARMCD <- droplevels(adtte$ARMCD)
adtte$SEX <- droplevels(adtte$SEX)

mod <- coxph(
  formula = Surv(time = AVAL, event = 1 - CNSR) ~ (SEX + ARMCD)^2,
  data = adtte
)

mmat <- stats::model.matrix(mod)[1, ]
mmat[!mmat == 0] <- 0

}
\seealso{
\code{\link[=s_cox_multivariate]{s_cox_multivariate()}}.
}
\keyword{internal}
