% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tabulate_rbmi.R
\name{summarize_rbmi}
\alias{summarize_rbmi}
\title{Analyze function for tabulating LS means estimates from tidied
\code{rbmi} \code{pool} results.}
\usage{
summarize_rbmi(
  lyt,
  ...,
  table_names = "rbmi_summary",
  .stats = NULL,
  .formats = NULL,
  .indent_mods = NULL,
  .labels = NULL
)
}
\arguments{
\item{lyt}{(\code{layout})\cr input layout where analyses will be added to.}

\item{...}{additional argument.}

\item{table_names}{(\code{character})\cr this can be customized in case that the same \code{vars} are analyzed multiple times,
to avoid warnings from \code{rtables}.}

\item{.stats}{(\code{character})\cr statistics to select for the table.}

\item{.formats}{(named \code{character} or \code{list})\cr formats for the statistics.}

\item{.indent_mods}{(named \code{integer})\cr indent modifiers for the labels.}

\item{.labels}{(named \code{character})\cr labels for the statistics (without indent).}
}
\value{
\code{rtables} layout for tabulating LS means estimates from tidied
\code{rbmi} \code{pool} results.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
}
\examples{
library(rtables)
library(dplyr)
library(broom)

data("rbmi_test_data")
pool_obj <- rbmi_test_data

df <- tidy(pool_obj)

basic_table() \%>\%
  split_cols_by("group", ref_group = levels(df$group)[1]) \%>\%
  split_rows_by("visit", split_label = "Visit", label_pos = "topleft") \%>\%
  summarize_rbmi() \%>\%
  build_table(df)

}
