% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/basic_tensor.R
\name{fnorm}
\alias{fnorm}
\title{Frobenius norm of an array.}
\usage{
fnorm(X)
}
\arguments{
\item{X}{An array, a matrix, or a vector.}
}
\value{
The square root of the sum of the squared elements of
    \code{X}.
}
\description{
Calculates the Frobenius norm of an array.
}
\details{
The Frobenius norm of an array is the square root of the sum of its
squared elements. This function works for vector and matrix
arguments as well.
}
\examples{
X <- c(1:8)
Y <- matrix(1:8, nrow = 2)
Z <- array(1:8, dim = c(2, 2, 2))
fnorm(X)
fnorm(Y)
fnorm(Z)
}
\author{
David Gerard.
}

