% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tensor_decomp.R
\name{hosvd}
\alias{hosvd}
\title{(Truncated-)Higher-order SVD}
\usage{
hosvd(tnsr, ranks = NULL)
}
\arguments{
\item{tnsr}{Tensor with K modes}

\item{ranks}{a vector of desired modes in the output core tensor, default is \code{tnsr@modes}}
}
\value{
a list containing the following:\describe{
\item{\code{Z}}{core tensor with modes speficied by \code{ranks}}
\item{\code{U}}{a list of orthogonal matrices, one for each mode}
\item{\code{est}}{estimate of \code{tnsr} after compression}
\item{\code{fnorm_resid}}{the Frobenius norm of the error \code{fnorm(est-tnsr)} - if there was no truncation, then this is on the order of mach_eps * fnorm. }
}
}
\description{
Higher-order SVD of a K-Tensor. Write the K-Tensor as a (m-mode) product of a core Tensor (possibly smaller modes) and K orthogonal factor matrices. Truncations can be specified via \code{ranks} (making them smaller than the original modes of the K-Tensor will result in a truncation). For the mathematical details on HOSVD, consult Lathauwer et. al. (2000).
}
\details{
A progress bar is included to help monitor operations on large tensors.
}
\note{
The length of \code{ranks} must match \code{tnsr@num_modes}.
}
\examples{
tnsr <- rand_tensor(c(6,7,8))
hosvdD <-hosvd(tnsr)
hosvdD$fnorm_resid
hosvdD2 <-hosvd(tnsr,ranks=c(3,3,4))
hosvdD2$fnorm_resid
}
\references{
L. Lathauwer, B.Moor, J. Vandewalle, "A multilinear singular value decomposition". Journal of Matrix Analysis and Applications 2000, Vol. 21, No. 4, pp. 1253–1278.
}
\seealso{
\code{\link{tucker}}
}
