% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tensorboard.R
\name{tensorboard}
\alias{tensorboard}
\title{TensorBoard Visualization Tool}
\usage{
tensorboard(
  log_dir,
  action = c("start", "stop"),
  host = "127.0.0.1",
  port = "auto",
  launch_browser = getOption("tensorflow.tensorboard.browser", interactive()),
  reload_interval = 5,
  purge_orphaned_data = TRUE
)
}
\arguments{
\item{log_dir}{Directories to scan for training logs. If this is a named
character vector then the specified names will be used as aliases within
TensorBoard.}

\item{action}{Specify whether to start or stop TensorBoard (TensorBoard will
be stopped automatically when the R session from which it is launched is
terminated).}

\item{host}{Host for serving TensorBoard}

\item{port}{Port for serving TensorBoard. If "auto" is specified (the
default) then an unused port will be chosen automatically.}

\item{launch_browser}{Open a web browser for TensorBoard after launching.
Defaults to \code{TRUE} in interactive sessions. When running under RStudio uses
an RStudio window by default (pass a function e.g. \code{\link[utils:browseURL]{utils::browseURL()}} to
open in an external browser). Use the \code{tensorflow.tensorboard.browser}
option to establish a global default behavior.}

\item{reload_interval}{How often the backend should load more data.}

\item{purge_orphaned_data}{Whether to purge data that may have been orphaned
due to TensorBoard restarts. Disabling purge_orphaned_data can be used to
debug data disappearance.}
}
\value{
URL for browsing TensorBoard (invisibly).
}
\description{
TensorBoard is a tool inspecting and understanding your TensorFlow runs and
graphs.
}
\details{
When TensorBoard is passed a logdir at startup, it recursively walks
the directory tree rooted at logdir looking for subdirectories that contain
tfevents data. Every time it encounters such a subdirectory, it loads it as
a new run, and the frontend will organize the data accordingly.

The TensorBoard process will be automatically destroyed when the R session
in which it is launched exits. You can pass \code{action = "stop"} to manually
terminate TensorBoard.
}
