% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R
\name{as_tensor}
\alias{as_tensor}
\alias{as_tensor.default}
\alias{as_tensor.double}
\title{as_tensor}
\usage{
as_tensor(x, dtype = NULL, ..., name = NULL)

\method{as_tensor}{default}(x, dtype = NULL, ..., shape = NULL, name = NULL)

\method{as_tensor}{double}(x, dtype = NULL, ..., name = NULL)
}
\arguments{
\item{x}{object to convert}

\item{dtype}{\code{NULL}, a tensorflow dtype (\code{tf$int32}), or something coercible
to one (e.g. a string \code{"int32"})}

\item{..., }{ignored}

\item{name}{\code{NULL} or a string. Useful for debugging in graph mode, ignored
while in eager mode.}

\item{shape}{an integer vector, tensor, or \code{tf.TensorShape}. Can contain up
to 1 unspecified dimension, encoded as a \code{-1} or \code{NA}. This will reshape
\code{x} using row-major (C-style) semantics. It will prefer reshaping using
non-graph operations if possible, but will otherwise invoke \code{tf$reshape()}.
If \code{x} is a scalar and the requested \code{shape} is fully defined or a tensor,
the value of \code{x} will be recycled to fill a tensor of the requested shape
(it will dispatch to \code{tf$fill()}).}
}
\value{
a tensorflow tensor
}
\description{
Coerce objects to tensorflow tensors (potentially of a specific dtype). The
provided default methods will call
\href{https://www.tensorflow.org/api_docs/python/tf/convert_to_tensor}{\code{tf.convert_to_tensor}}
and \href{https://www.tensorflow.org/api_docs/python/tf/cast}{\code{tf.cast}} as
appropriate.
}
\examples{
\dontrun{
as_tensor(42, "int32")
as_tensor(as_tensor(42))
}
}
