% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tenAR.R
\name{matAR.RR.est}
\alias{matAR.RR.est}
\title{Estimation for Reduced Rank MAR(1) Model}
\usage{
matAR.RR.est(xx, method, A1.init=NULL, A2.init=NULL,Sig1.init=NULL,Sig2.init=NULL,
k1=NULL, k2=NULL, niter=200,tol=1e-4)
}
\arguments{
\item{xx}{\eqn{T \times d_1 \times d_2} matrix-valued time series, \eqn{T} is the length of the series.}

\item{method}{character string, specifying the method of the estimation to be used. \describe{
 \item{\code{"RRLSE",}}{Least squares.}
 \item{\code{"RRMLE",}}{MLE under a separable cov(vec(\eqn{E_t})).}
}}

\item{A1.init}{initial value of \eqn{A_1}. The default is the identity matrix.}

\item{A2.init}{initial value of \eqn{A_2}. The default is the identity matrix.}

\item{Sig1.init}{only if \code{method=RRMLE}, initial value of \eqn{\Sigma_1}. The default is the identity matrix.}

\item{Sig2.init}{only if \code{method=RRMLE}, initial value of \eqn{\Sigma_2}. The default is the identity matrix.}

\item{k1}{rank of \eqn{A_1}, a positive integer.}

\item{k2}{rank of \eqn{A_2}, a positive integer.}

\item{niter}{maximum number of iterations if error stays above \code{tol}.}

\item{tol}{relative Frobenius norm error tolerance.}
}
\value{
return a list containing the following:\describe{
\item{\code{A1}}{estimator of \eqn{A_1}, a \eqn{d_1} by \eqn{d_1} matrix.}
\item{\code{A2}}{estimator of \eqn{A_2}, a \eqn{d_2} by \eqn{d_2} matrix.}
\item{\code{loading}}{a list of estimated \eqn{U_i}, \eqn{V_i}, 
where we write \eqn{A_i=U_iD_iV_i} as the singular value decomposition (SVD) of \eqn{A_i}, \eqn{i = 1,2}.}
\item{\code{Sig1}}{only if \code{method=MLE}, when \eqn{\mathrm{Cov}(\mathrm{vec}(E_t))=\Sigma_2 \otimes \Sigma_1}.}
\item{\code{Sig2}}{only if \code{method=MLE}, when \eqn{\mathrm{Cov}(\mathrm{vec}(E_t))=\Sigma_2 \otimes \Sigma_1}.}
\item{\code{res}}{residuals.}
\item{\code{Sig}}{sample covariance matrix of the residuals vec(\eqn{\hat E_t}).}
\item{\code{cov}}{a list containing \describe{
 \item{\code{Sigma}}{asymptotic covariance matrix of (vec( \eqn{\hat A_1}),vec(\eqn{\hat A_2^{\top}})).}
 \item{\code{Theta1.u}, \code{Theta1.v}}{asymptotic covariance matrix of vec(\eqn{\hat U_1}), vec(\eqn{\hat V_1}).}
 \item{\code{Theta2.u}, \code{Theta2.v}}{asymptotic covariance matrix of vec(\eqn{\hat U_2}), vec(\eqn{\hat V_2}).}
}}
\item{\code{sd.A1}}{element-wise standard errors of \eqn{\hat A_1}, aligned with \code{A1}.}
\item{\code{sd.A2}}{element-wise standard errors of \eqn{\hat A_2}, aligned with \code{A2}.}
\item{\code{niter}}{number of iterations.}
\item{\code{BIC}}{value of the extended Bayesian information criterion.}
}
}
\description{
Estimation of the reduced rank MAR(1) model, using least squares (RRLSE) or MLE (RRMLE), as determined by the value of \code{method}.
}
\details{
The reduced rank MAR(1) model takes the form:
\deqn{X_t =  A_1 X_{t-1} A_2^{^\top} + E_t,}
where \eqn{A_i} are \eqn{d_i \times d_i} coefficient matrices of ranks \eqn{\mathrm{rank}(A_i) = k_i \le d_i}, \eqn{i=1,2}. For the MLE method we also assume
 \deqn{\mathrm{Cov}(\mathrm{vec}(E_t))=\Sigma_2 \otimes \Sigma_1}
}
\examples{
set.seed(333)
dim <- c(3,3)
xx <- tenAR.sim(t=500, dim, R=2, P=1, rho=0.5, cov='iid')
est <- matAR.RR.est(xx, method="RRLSE", k1=1, k2=1)
}
\references{
Reduced Rank Autoregressive Models for Matrix Time Series, by Han Xiao, Yuefeng Han, Rong Chen and Chengcheng Liu.
}
