% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/equ8.R
\name{equ8}
\alias{equ8}
\title{Equation 8}
\usage{
equ8(temp, rate, augment = F, plot_profile = F, return_fit = F)
}
\arguments{
\item{temp}{temperature (in celsius or Kelvin)}

\item{rate}{rate measurement}

\item{augment}{logical wether the dataset with fits should be returned instead of the parameter values}

\item{plot_profile}{logical should the model fitting profile be plotted}

\item{return_fit}{logical wether the model fit object should be returned}
}
\value{
depends on augment: if false, fitting parameters or fitted data
}
\description{
Equation in Li & Dickie (1987) citing Stoermer & Ladewski (1976): a*exp(-0.5*((temp-tref)/b)^2)
}
\examples{
output <- with(Emiliania_huxleyi, equ8(temp=temp, rate=rate))
}
