% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tcata.R
\encoding{UTF-8}
\name{get.smooth}
\alias{get.smooth}
\title{Convenience function for curve smoothing}
\usage{
get.smooth(y, w = NULL, spar = 0.5, low.bound = 0, up.bound = 1)
}
\arguments{
\item{y}{the vector of proportions (or counts) to be smoothed. If a data frame is provided then smoothing is conducted on each row.}

\item{w}{an optional vector of weights; see \code{\link[stats]{smooth.spline}}}

\item{spar}{smoothing parameter; see \code{\link[stats]{smooth.spline}}}

\item{low.bound}{lower bound for smoothed proportions}

\item{up.bound}{upper bound for smoothed proportions}
}
\value{
out smoothed vector (or data frame with smoothed rows)
}
\description{
Smooth TCATA curves, constraining smooth within \code{low.bound} and \code{up.bound}.
}
\examples{
# example using 'syrah' data set
low1 <- t(syrah[seq(3, 1026, by = 6), -c(1:4)])
colnames(low1) <- 10:180
x <- get.smooth(low1)
round(x, 3)
}
\references{
Castura, J.C., Antúnez, L., Giménez, A., Ares, G. (2016). Temporal check-all-that-apply (TCATA): A novel temporal sensory method for characterizing products. \emph{Food Quality and Preference}, 47, 79-90. \url{http://dx.doi.org/10.1016/j.foodqual.2015.06.017}
}
\seealso{
\code{\link[stats]{smooth.spline}}, \code{\link[stats]{predict}}
}
