% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tds.R
\encoding{UTF-8}
\name{tds.diff.plot}
\alias{tds.diff.plot}
\title{Plot TDS difference curves}
\usage{
tds.diff.plot(X, times = NULL, attributes = NULL, xlab = "Time (seconds)",
  ylab = "Dominance rate", line.col = 1, lty = 1, lwd = 1, main = "")
}
\arguments{
\item{X}{matrix of differences in dominance rates (Attributes in rows, Times in columns).}

\item{times}{a vector of times, corresponding to the times in \code{X}.}

\item{attributes}{a vector of attribute labels, corresponding to the attributes in \code{X}.}

\item{xlab, ylab}{Labels for the x and y axes; see \code{\link[graphics]{plot}}}

\item{line.col}{A vector of colors for lines corresponding to \code{attributes}; see \code{\link[graphics]{par}}}

\item{lty, lwd}{line type and weight for attributes; see \code{\link[graphics]{par}}}

\item{main}{plot title; see \code{\link[graphics]{plot}}}
}
\description{
Plots TDS difference curves based on differences in dominance counts or dominace rates.
}
\details{
Currently the differences in dominance rates are always displayed. Suppression of differences in dominances rates within a threshold range is not yet implemented.
}
\examples{
# example using 'bars' data set
bars.m <- aggregate(bars[, -c(1:4)], list(samples = bars$sample, attribute = bars$attribute), mean)
bars.m <- bars.m[order(bars.m$sample, bars.m$attribute), ]
attributes <- unique(bars$attribute)
times <- get.times(colnames(bars.m)[-c(1:2)])
bar1 <- bars.m[bars.m$sample == 1, -c(1:2)]
bar2 <- bars.m[bars.m$sample == 2, -c(1:2)]
diff.1vs2 <- get.smooth(bar1 - bar2, low.bound = -1, up.bound = 1)
tds.diff.plot(diff.1vs2, times = times, attributes = attributes,
                lwd = 2, main = "TDS Differences (Bar 1 - Bar 2)")
}
\references{
Pineau, N., Schlich, P., Cordelle, S., Mathonnière, C., Issanchou, S., Imbert, A., Rogeaux, M., Etiévant, P., & Köster, E. (2009). Temporal dominance of sensations: Construction of the TDS curves and comparison with time–intensity.  \emph{Food Quality and Preference}, 20, 450–455. \url{http://dx.doi.org/10.1016/j.foodqual.2009.04.005}
}

