#' Plate Boundaries on the Earth
#'
#' Global set of present plate boundaries on the Earth based on NUVEL-1 model by
#' DeMets et al. 1990
#'
#' @docType data
#'
#' @usage data('nuvel1_plates')
#'
#' @format An object of class `sf`
#'
#' @references DeMets, C., Gordon, R. G., Argus, D. F., & Stein, S. (1990).
#' Current plate motions. *Geophysical Journal International*, **101**(2),
#' 425-478. \doi{10.1111/j.1365-246X.1990.tb06579.x}.
#'
#' @keywords datasets
#'
#' @examples
#' data("nuvel1_plates")
#' head("nuvel1_plates")
"nuvel1_plates"
