% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FilterStateExpr.R
\docType{class}
\name{FilterStateExpr}
\alias{FilterStateExpr}
\title{\code{FilterStateExpr} \code{R6} class}
\description{
Sister class to \code{FilterState} that handles arbitrary filter expressions.
}
\details{
Creates a filter state around a predefined condition call (logical predicate).
The condition call is independent of the data
and the filter card allows no interaction (the filter is always fixed).
}
\examples{
# use non-exported function from teal.slice
include_js_files <- getFromNamespace("include_js_files", "teal.slice")
include_css_files <- getFromNamespace("include_css_files", "teal.slice")
FilterStateExpr <- getFromNamespace("FilterStateExpr", "teal.slice")

filter_state <- FilterStateExpr$new(
  slice = teal_slice(
    dataname = "x",
    id = "FA",
    title = "Adult females",
    expr = "sex == 'F' & age >= 18"
  )
)
filter_state$get_call()

# working filter in an app
library(shiny)
library(shinyjs)

ui <- fluidPage(
  useShinyjs(),
  include_css_files(pattern = "filter-panel"),
  include_js_files(pattern = "count-bar-labels"),
  column(4, tags$div(
    tags$h4("ChoicesFilterState"),
    filter_state$ui("fs")
  )),
  column(8, tags$div(
    tags$h4("Condition (i.e. call)"), # display the condition call generated by this FilterState
    textOutput("condition_choices"), tags$br(),
    tags$h4("Unformatted state"), # display raw filter state
    textOutput("unformatted_choices"), tags$br(),
    tags$h4("Formatted state"), # display human readable filter state
    textOutput("formatted_choices"), tags$br()
  ))
)

server <- function(input, output, session) {
  filter_state$server("fs")
  output$condition_choices <- renderPrint(filter_state$get_call())
  output$formatted_choices <- renderText(filter_state$format())
  output$unformatted_choices <- renderPrint(filter_state$get_state())
}

if (interactive()) {
  shinyApp(ui, server)
}

}
\keyword{internal}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-FilterStateExpr-new}{\code{FilterStateExpr$new()}}
\item \href{#method-FilterStateExpr-format}{\code{FilterStateExpr$format()}}
\item \href{#method-FilterStateExpr-print}{\code{FilterStateExpr$print()}}
\item \href{#method-FilterStateExpr-get_state}{\code{FilterStateExpr$get_state()}}
\item \href{#method-FilterStateExpr-set_state}{\code{FilterStateExpr$set_state()}}
\item \href{#method-FilterStateExpr-get_call}{\code{FilterStateExpr$get_call()}}
\item \href{#method-FilterStateExpr-finalize}{\code{FilterStateExpr$finalize()}}
\item \href{#method-FilterStateExpr-server}{\code{FilterStateExpr$server()}}
\item \href{#method-FilterStateExpr-ui}{\code{FilterStateExpr$ui()}}
\item \href{#method-FilterStateExpr-clone}{\code{FilterStateExpr$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FilterStateExpr-new"></a>}}
\if{latex}{\out{\hypertarget{method-FilterStateExpr-new}{}}}
\subsection{Method \code{new()}}{
Initialize a \code{FilterStateExpr} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FilterStateExpr$new(slice)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{slice}}{(\code{teal_slice_expr})}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Object of class \code{FilterStateExpr}, invisibly.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FilterStateExpr-format"></a>}}
\if{latex}{\out{\hypertarget{method-FilterStateExpr-format}{}}}
\subsection{Method \code{format()}}{
Returns a formatted string representing this \code{FilterStateExpr} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FilterStateExpr$format(show_all = FALSE, trim_lines = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{show_all}}{(\code{logical(1)}) passed to \code{format.teal_slice}}

\item{\code{trim_lines}}{(\code{logical(1)}) passed to \code{format.teal_slice}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{character(1)} the formatted string
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FilterStateExpr-print"></a>}}
\if{latex}{\out{\hypertarget{method-FilterStateExpr-print}{}}}
\subsection{Method \code{print()}}{
Prints this \code{FilterStateExpr} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FilterStateExpr$print(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{arguments passed to the \code{format} method}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{NULL}, invisibly.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FilterStateExpr-get_state"></a>}}
\if{latex}{\out{\hypertarget{method-FilterStateExpr-get_state}{}}}
\subsection{Method \code{get_state()}}{
Returns a complete description of this filter state.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FilterStateExpr$get_state()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A \code{teal_slice} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FilterStateExpr-set_state"></a>}}
\if{latex}{\out{\hypertarget{method-FilterStateExpr-set_state}{}}}
\subsection{Method \code{set_state()}}{
Does nothing. Exists for compatibility.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FilterStateExpr$set_state(state)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{state}}{(\code{teal_slice})}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{self}, invisibly.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FilterStateExpr-get_call"></a>}}
\if{latex}{\out{\hypertarget{method-FilterStateExpr-get_call}{}}}
\subsection{Method \code{get_call()}}{
Get reproducible call.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FilterStateExpr$get_call(dataname)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{dataname}}{(\code{ignored}) for a consistency with \code{FilterState}

Returns reproducible condition call for current selection relevant
for selected variable type.
Method is using internal reactive values which makes it reactive
and must be executed in reactive or isolated context.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{call} or \code{NULL}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FilterStateExpr-finalize"></a>}}
\if{latex}{\out{\hypertarget{method-FilterStateExpr-finalize}{}}}
\subsection{Method \code{finalize()}}{
Destroy inputs and observers stored in \code{private$session_bindings}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FilterStateExpr$finalize()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
\code{NULL}, invisibly.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FilterStateExpr-server"></a>}}
\if{latex}{\out{\hypertarget{method-FilterStateExpr-server}{}}}
\subsection{Method \code{server()}}{
\code{shiny} module server.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FilterStateExpr$server(id, remove_callback)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{(\code{character(1)})
\code{shiny} module instance id.}

\item{\code{remove_callback}}{(\code{function})
callback to handle removal of this \code{FilterState} object from \code{state_list}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Reactive expression signaling that the remove button has been clicked.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FilterStateExpr-ui"></a>}}
\if{latex}{\out{\hypertarget{method-FilterStateExpr-ui}{}}}
\subsection{Method \code{ui()}}{
\code{shiny} module UI.
The UI for this class contains simple message stating that it is not supported.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FilterStateExpr$ui(id, parent_id = "cards")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{(\code{character(1)})
\code{shiny} module instance id.}

\item{\code{parent_id}}{(\code{character(1)})
id of the \code{FilterStates} card container.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FilterStateExpr-clone"></a>}}
\if{latex}{\out{\hypertarget{method-FilterStateExpr-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FilterStateExpr$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
