% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qenv-constructor.R, R/qenv-eval_code.R,
%   R/qenv-get_code.R, R/qenv-within.R
\name{qenv}
\alias{qenv}
\alias{new_qenv}
\alias{new_qenv,environment,expression-method}
\alias{new_qenv,environment,character-method}
\alias{new_qenv,environment,language-method}
\alias{new_qenv,environment,missing-method}
\alias{new_qenv,missing,missing-method}
\alias{eval_code}
\alias{eval_code,qenv,character-method}
\alias{eval_code,qenv,language-method}
\alias{eval_code,qenv,expression-method}
\alias{eval_code,qenv.error,ANY-method}
\alias{get_code}
\alias{get_code,qenv-method}
\alias{get_code,qenv.error-method}
\alias{within.qenv}
\title{Code tracking with \code{qenv} object}
\usage{
qenv()

new_qenv(env = new.env(parent = parent.env(.GlobalEnv)), code = character())

eval_code(object, code)

get_code(object, deparse = TRUE, ...)

\method{within}{qenv}(data, expr, ...)
}
\arguments{
\item{env}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} (\code{environment})
Environment being a result of the \code{code} evaluation.}

\item{code}{(\code{character} or \code{language}) code to evaluate. If \code{character}, comments are retained.}

\item{object}{(\code{qenv})}

\item{deparse}{(\code{logical(1)}) flag specifying whether to return code as \code{character} or \code{expression}.}

\item{...}{see \code{Details}}

\item{data}{(\code{qenv})}

\item{expr}{(\code{expression}) to evaluate. Must be inline code, see \verb{Using language objects...}}
}
\value{
\code{qenv} and \code{new_qenv} return a \code{qenv} object.

\code{eval_code} returns a \code{qenv} object with \code{expr} evaluated or \code{qenv.error} if evaluation fails.

\code{get_code} returns the traced code (from \verb{@code} slot) in the form specified by \code{deparse}.

\code{within} returns a \code{qenv} object with \code{expr} evaluated or \code{qenv.error} if evaluation fails.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Create a \code{qenv} object and evaluate code in it to track code history.
}
\details{
\code{qenv()} instantiates a \code{qenv} with an empty environment.
Any changes must be made by evaluating code in it with \code{eval_code} or \code{within}, thereby ensuring reproducibility.

\code{new_qenv()} (\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} and not recommended)
can instantiate a \code{qenv} object with data in the environment and code registered.

\code{eval_code} evaluates given code in the \code{qenv} environment and appends it to the \code{code} slot.
Thus, if the \code{qenv} had been instantiated empty, contents of the environment are always a result of the stored code.

\code{get_code} retrieves the code stored in the \code{qenv}. \code{...} passes arguments to methods.

\code{within} is a convenience function for evaluating inline code inside the environment of a \code{qenv}.
It is a method for the \code{base} generic that wraps \code{eval_code} to provide a simplified way of passing code.
\code{within} accepts only inline expressions (both simple and compound) and allows for injecting values into \code{expr}
through the \code{...} argument:
as \code{name:value} pairs are passed to \code{...}, \code{name} in \code{expr} will be replaced with \code{value}.
}
\section{Using language objects with \code{within}}{

Passing language objects to \code{expr} is generally not intended but can be achieved with \code{do.call}.
Only single \code{expression}s will work and substitution is not available. See examples.
}

\examples{
# create empty qenv
qenv()

# create qenv with data and code (deprecated)
new_qenv(env = list2env(list(a = 1)), code = quote(a <- 1))
new_qenv(env = list2env(list(a = 1)), code = parse(text = "a <- 1", keep.source = TRUE))
new_qenv(env = list2env(list(a = 1)), code = "a <- 1")

# evaluate code in qenv
q <- qenv()
q <- eval_code(q, "a <- 1")
q <- eval_code(q, quote(library(checkmate)))
q <- eval_code(q, expression(assert_number(a)))

# retrieve code
get_code(q)
get_code(q, deparse = FALSE)

# evaluate code using within
q <- qenv()
q <- within(q, {
  i <- iris
})
q <- within(q, {
  m <- mtcars
  f <- faithful
})
q
get_code(q)

# inject values into code
q <- qenv()
q <- within(q, i <- iris)
within(q, print(dim(subset(i, Species == "virginica"))))
within(q, print(dim(subset(i, Species == species)))) # fails
within(q, print(dim(subset(i, Species == species))), species = "versicolor")
species_external <- "versicolor"
within(q, print(dim(subset(i, Species == species))), species = species_external)

# pass language objects
expr <- expression(i <- iris, m <- mtcars)
within(q, expr) # fails
do.call(within, list(q, expr))

exprlist <- list(expression(i <- iris), expression(m <- mtcars))
within(q, exprlist) # fails
do.call(within, list(q, do.call(c, exprlist)))

}
\seealso{
\code{\link[base:with]{base::within()}}, \code{\link[=get_var]{get_var()}}, \code{\link[=get_env]{get_env()}}, \code{\link[=get_warnings]{get_warnings()}}, \code{\link[=join]{join()}}, \code{\link[=concat]{concat()}}
}
