% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/frequency.R
\name{f.multi.daily}
\alias{f.multi.daily}
\title{Create a Multi-Day Frequency}
\usage{
f.multi.daily(date, k)
}
\arguments{
\item{date}{The date, which can be a list with \code{year}, \code{month}, and \code{day} elements.
It can also be an integer array with 3 elements for year, month, and day respectively,
or an object that can be used as an argument for the \code{base::as.Date} function.}

\item{k}{The number of days in the interval.}
}
\value{
An object of class \code{ldtf}. It is also a list with the following members:
\item{class}{Determines the class of this frequency.}
\item{year}{Determines the \code{year}.}
\item{month}{Determines the \code{month}.}
\item{day}{Determines the \code{day}.}
\item{k}{Determines the value: \code{k}.}
}
\description{
Use this function to create a frequency for time-series data that occurs every \code{k} days. The first day of the interval is used as the reference.
}
\details{
In order to use the \code{\link{as.frequency}} function for this type of frequency,
you need the following information:
\itemize{
\item \strong{Character Format}: The first day of the interval in \code{"YYYYMMDD"} format.
\item \strong{Class Id}: \code{"d#"} (where # is the value of \code{k}; e.g., d3 means every 3 days)
}
}
\examples{

md0 <- f.multi.daily(c(2023, 1, 2), 4) # This is 2/1/2023. Next observation belongs to 6/1/2023.

md0_value_str <-  as.character(md0) # this will be '20230102'.
md0_class_str <- get.class.id(md0) # this will be 'd4'.

md_new <- as.frequency("20230109", "d") # This is 9/1/2023.

# Don't use invalid or unsupported dates:
\donttest{
md_invalid <- try(as.frequency("1399109", "d3")) # this is a too old date and unsupported
md_invalid <- try(as.frequency("20230132", "d4")) # invalid day in month
md_invalid <- try(as.frequency("20231331", "d5")) # invalid month
}

}
